/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12.message;

import io.netty.handler.codec.DateFormatter;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http2.Http2Headers;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.http12.HttpChannel;
import org.apache.dubbo.remoting.http12.HttpCookie;
import org.apache.dubbo.remoting.http12.HttpHeaderNames;
import org.apache.dubbo.remoting.http12.HttpHeaders;
import org.apache.dubbo.remoting.http12.HttpMetadata;
import org.apache.dubbo.remoting.http12.HttpMethods;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpUtils;
import org.apache.dubbo.remoting.http12.RequestMetadata;
import org.apache.dubbo.remoting.http12.h2.Http2Header;

public class DefaultHttpRequest
implements HttpRequest {
    private final HttpMetadata metadata;
    private final HttpChannel channel;
    private final HttpHeaders headers;
    private String method;
    private String uri;
    private String contentType;
    private String charset;
    private List<HttpCookie> cookies;
    private List<Locale> locales;
    private QueryStringDecoder decoder;
    private HttpPostRequestDecoder postDecoder;
    private boolean postParsed;
    private Map<String, Object> attributes;
    private InputStream inputStream;

    public DefaultHttpRequest(HttpMetadata metadata, HttpChannel channel) {
        this.metadata = metadata;
        this.channel = channel;
        this.headers = metadata.headers();
        if (!(metadata instanceof RequestMetadata)) {
            throw new UnsupportedOperationException();
        }
        RequestMetadata requestMetadata = (RequestMetadata)metadata;
        this.method = requestMetadata.method();
        this.uri = requestMetadata.path();
    }

    public HttpMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public boolean isHttp2() {
        return this.metadata instanceof Http2Header;
    }

    @Override
    public String method() {
        return this.method;
    }

    @Override
    public void setMethod(String method) {
        this.method = method;
    }

    @Override
    public String uri() {
        return this.uri;
    }

    @Override
    public void setUri(String uri) {
        this.uri = uri;
        this.decoder = null;
    }

    @Override
    public String path() {
        return this.getDecoder().path();
    }

    @Override
    public String rawPath() {
        return this.getDecoder().rawPath();
    }

    @Override
    public String query() {
        return this.getDecoder().rawQuery();
    }

    @Override
    public String header(CharSequence name) {
        return this.headers.getFirst(name);
    }

    @Override
    public List<String> headerValues(CharSequence name) {
        return this.headers.get(name);
    }

    @Override
    public Date dateHeader(CharSequence name) {
        String value = this.headers.getFirst(name);
        return StringUtils.isEmpty(value) ? null : DateFormatter.parseHttpDate((CharSequence)value);
    }

    @Override
    public boolean hasHeader(CharSequence name) {
        return this.headers.containsKey(name);
    }

    @Override
    public Collection<String> headerNames() {
        return this.headers.names();
    }

    @Override
    public HttpHeaders headers() {
        return this.headers;
    }

    @Override
    public void setHeader(CharSequence name, String value) {
        this.headers.set(name, value);
    }

    @Override
    public void setHeader(CharSequence name, Date value) {
        this.headers.set(name, DateFormatter.format((Date)value));
    }

    @Override
    public void setHeader(CharSequence name, List<String> values) {
        this.headers.set(name, values);
    }

    @Override
    public Collection<HttpCookie> cookies() {
        List<HttpCookie> cookies = this.cookies;
        if (cookies == null) {
            this.cookies = cookies = HttpUtils.decodeCookies(this.header(HttpHeaderNames.COOKIE.getKey()));
        }
        return cookies;
    }

    @Override
    public HttpCookie cookie(String name) {
        List<HttpCookie> cookies = this.cookies;
        if (cookies == null) {
            this.cookies = cookies = HttpUtils.decodeCookies(this.header(HttpHeaderNames.COOKIE.getKey()));
        }
        int size = cookies.size();
        for (int i = 0; i < size; ++i) {
            HttpCookie cookie = cookies.get(i);
            if (!cookie.name().equals(name)) continue;
            return cookie;
        }
        return null;
    }

    @Override
    public int contentLength() {
        String value = this.headers.getFirst(HttpHeaderNames.CONTENT_LENGTH.getKey());
        return value == null ? 0 : Integer.parseInt(value);
    }

    @Override
    public String contentType() {
        String contentType = this.contentType;
        if (contentType == null) {
            contentType = this.headers.getFirst(HttpHeaderNames.CONTENT_TYPE.getKey());
            this.contentType = contentType = contentType == null ? "" : contentType.trim();
        }
        return contentType.isEmpty() ? null : contentType;
    }

    @Override
    public void setContentType(String contentType) {
        this.setContentType0(contentType == null ? "" : contentType.trim());
        this.charset = null;
    }

    private void setContentType0(String contentType) {
        this.contentType = contentType;
        this.headers.set(HttpHeaderNames.CONTENT_TYPE.getKey(), this.contentType());
    }

    @Override
    public String mediaType() {
        String contentType = this.contentType();
        if (contentType == null) {
            return null;
        }
        int index = contentType.indexOf(59);
        return index == -1 ? contentType : contentType.substring(0, index);
    }

    @Override
    public String charset() {
        String charset = this.charset;
        if (charset == null) {
            int index;
            String contentType = this.contentType();
            charset = contentType == null ? "" : ((index = contentType.lastIndexOf("charset=")) == -1 ? "" : contentType.substring(index + 8).trim());
            this.charset = charset;
        }
        return charset.isEmpty() ? null : charset;
    }

    @Override
    public Charset charsetOrDefault() {
        String charset = this.charset();
        return charset == null ? StandardCharsets.UTF_8 : Charset.forName(charset);
    }

    @Override
    public void setCharset(String charset) {
        String contentType = this.contentType();
        if (contentType != null) {
            this.setContentType0(contentType + "; " + "charset=" + charset);
        }
        this.charset = charset;
    }

    @Override
    public String accept() {
        return this.headers.getFirst(HttpHeaderNames.ACCEPT.getKey());
    }

    @Override
    public Locale locale() {
        return this.locales().get(0);
    }

    @Override
    public List<Locale> locales() {
        List<Locale> locales = this.locales;
        if (locales == null) {
            locales = HttpUtils.parseAcceptLanguage(this.headers.getFirst(HttpHeaderNames.CONTENT_LANGUAGE.getKey()));
            if (locales.isEmpty()) {
                locales.add(Locale.getDefault());
            }
            this.locales = locales;
        }
        return locales;
    }

    @Override
    public String scheme() {
        String scheme = this.headers.getFirst("x-forwarded-proto");
        if (this.isHttp2()) {
            scheme = this.headers.getFirst((CharSequence)Http2Headers.PseudoHeaderName.SCHEME.value());
        }
        return scheme == null ? "https" : scheme;
    }

    @Override
    public String serverHost() {
        String host = this.getHost0();
        return host == null ? this.localHost() + ':' + this.localPort() : host;
    }

    @Override
    public String serverName() {
        String host = this.headers.getFirst("x-forwarded-host");
        if (host != null) {
            return host;
        }
        host = this.getHost0();
        if (host != null) {
            int index = host.lastIndexOf(58);
            return index == -1 ? host : host.substring(0, index);
        }
        return this.localHost();
    }

    @Override
    public int serverPort() {
        String port = this.headers.getFirst("x-forwarded-port");
        if (port != null) {
            return Integer.parseInt(port);
        }
        String host = this.getHost0();
        if (host != null) {
            int index = host.lastIndexOf(58);
            return index == -1 ? -1 : Integer.parseInt(host.substring(0, index));
        }
        return this.localPort();
    }

    private String getHost0() {
        return this.headers.getFirst((CharSequence)(this.isHttp2() ? Http2Headers.PseudoHeaderName.AUTHORITY.value() : HttpHeaderNames.HOST.getKey()));
    }

    @Override
    public String remoteHost() {
        return this.getRemoteAddress().getHostString();
    }

    @Override
    public String remoteAddr() {
        return this.getRemoteAddress().getAddress().getHostAddress();
    }

    @Override
    public int remotePort() {
        return this.getRemoteAddress().getPort();
    }

    private InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.channel.remoteAddress();
    }

    @Override
    public String localHost() {
        return this.getLocalAddress().getHostString();
    }

    @Override
    public String localAddr() {
        return this.getLocalAddress().getAddress().getHostAddress();
    }

    @Override
    public int localPort() {
        return this.getLocalAddress().getPort();
    }

    private InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.channel.localAddress();
    }

    @Override
    public String parameter(String name) {
        List values = (List)this.getDecoder().parameters().get(name);
        if (CollectionUtils.isNotEmpty(values)) {
            return (String)values.get(0);
        }
        HttpPostRequestDecoder postDecoder = this.getPostDecoder();
        if (postDecoder == null) {
            return null;
        }
        List items = postDecoder.getBodyHttpDatas(name);
        if (items == null) {
            return null;
        }
        int size = items.size();
        for (int i = 0; i < size; ++i) {
            InterfaceHttpData item = (InterfaceHttpData)items.get(i);
            if (item.getHttpDataType() != InterfaceHttpData.HttpDataType.Attribute) continue;
            return HttpUtils.readPostValue(item);
        }
        return this.formParameter(name);
    }

    @Override
    public String parameter(String name, String defaultValue) {
        String value = this.parameter(name);
        return value == null ? defaultValue : value;
    }

    @Override
    public List<String> parameterValues(String name) {
        ArrayList<String> values = (ArrayList<String>)this.getDecoder().parameters().get(name);
        HttpPostRequestDecoder postDecoder = this.getPostDecoder();
        if (postDecoder == null) {
            return values;
        }
        List items = postDecoder.getBodyHttpDatas(name);
        if (items == null) {
            return values;
        }
        int size = items.size();
        for (int i = 0; i < size; ++i) {
            InterfaceHttpData item = (InterfaceHttpData)items.get(i);
            if (item.getHttpDataType() != InterfaceHttpData.HttpDataType.Attribute) continue;
            if (values == null) {
                values = new ArrayList<String>();
            }
            values.add(HttpUtils.readPostValue(item));
        }
        return values;
    }

    @Override
    public String queryParameter(String name) {
        return CollectionUtils.first(this.queryParameterValues(name));
    }

    @Override
    public List<String> queryParameterValues(String name) {
        return (List)this.getDecoder().parameters().get(name);
    }

    @Override
    public Collection<String> queryParameterNames() {
        return this.getDecoder().parameters().keySet();
    }

    @Override
    public Map<String, List<String>> queryParameters() {
        return this.getDecoder().parameters();
    }

    @Override
    public String formParameter(String name) {
        HttpPostRequestDecoder postDecoder = this.getPostDecoder();
        if (postDecoder == null) {
            return null;
        }
        List items = postDecoder.getBodyHttpDatas(name);
        if (items == null) {
            return null;
        }
        int size = items.size();
        for (int i = 0; i < size; ++i) {
            InterfaceHttpData item = (InterfaceHttpData)items.get(i);
            if (item.getHttpDataType() != InterfaceHttpData.HttpDataType.Attribute) continue;
            return HttpUtils.readPostValue(item);
        }
        return null;
    }

    @Override
    public List<String> formParameterValues(String name) {
        HttpPostRequestDecoder postDecoder = this.getPostDecoder();
        if (postDecoder == null) {
            return null;
        }
        List items = postDecoder.getBodyHttpDatas(name);
        if (items == null) {
            return null;
        }
        ArrayList<String> values = null;
        int size = items.size();
        for (int i = 0; i < size; ++i) {
            InterfaceHttpData item = (InterfaceHttpData)items.get(i);
            if (item.getHttpDataType() != InterfaceHttpData.HttpDataType.Attribute) continue;
            if (values == null) {
                values = new ArrayList<String>();
            }
            values.add(HttpUtils.readPostValue(item));
        }
        return values == null ? Collections.emptyList() : values;
    }

    @Override
    public Collection<String> formParameterNames() {
        HttpPostRequestDecoder postDecoder = this.getPostDecoder();
        if (postDecoder == null) {
            return Collections.emptyList();
        }
        List items = postDecoder.getBodyHttpDatas();
        if (items == null) {
            return Collections.emptyList();
        }
        LinkedHashSet<String> names = null;
        int size = items.size();
        for (int i = 0; i < size; ++i) {
            InterfaceHttpData item = (InterfaceHttpData)items.get(i);
            if (item.getHttpDataType() != InterfaceHttpData.HttpDataType.Attribute) continue;
            if (names == null) {
                names = new LinkedHashSet<String>();
            }
            names.add(item.getName());
        }
        return names == null ? Collections.emptyList() : names;
    }

    @Override
    public boolean hasParameter(String name) {
        if (this.getDecoder().parameters().containsKey(name)) {
            return true;
        }
        HttpPostRequestDecoder postDecoder = this.getPostDecoder();
        if (postDecoder == null) {
            return false;
        }
        List items = postDecoder.getBodyHttpDatas(name);
        if (items == null) {
            return false;
        }
        int size = items.size();
        for (int i = 0; i < size; ++i) {
            InterfaceHttpData item = (InterfaceHttpData)items.get(i);
            if (item.getHttpDataType() != InterfaceHttpData.HttpDataType.Attribute) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<String> parameterNames() {
        Set<String> names = this.getDecoder().parameters().keySet();
        HttpPostRequestDecoder postDecoder = this.getPostDecoder();
        if (postDecoder == null) {
            return names;
        }
        List items = postDecoder.getBodyHttpDatas();
        if (items == null) {
            return names;
        }
        LinkedHashSet<String> allNames = null;
        int size = items.size();
        for (int i = 0; i < size; ++i) {
            InterfaceHttpData item = (InterfaceHttpData)items.get(i);
            if (item.getHttpDataType() != InterfaceHttpData.HttpDataType.Attribute) continue;
            if (allNames == null) {
                allNames = new LinkedHashSet<String>(names);
            }
            allNames.add(item.getName());
        }
        return allNames == null ? Collections.emptyList() : allNames;
    }

    @Override
    public Collection<HttpRequest.FileUpload> parts() {
        HttpPostRequestDecoder postDecoder = this.getPostDecoder();
        if (postDecoder == null) {
            return Collections.emptyList();
        }
        List items = postDecoder.getBodyHttpDatas();
        if (items == null) {
            return Collections.emptyList();
        }
        ArrayList<HttpRequest.FileUpload> fileUploads = new ArrayList<HttpRequest.FileUpload>();
        int size = items.size();
        for (int i = 0; i < size; ++i) {
            InterfaceHttpData item = (InterfaceHttpData)items.get(i);
            if (item.getHttpDataType() != InterfaceHttpData.HttpDataType.FileUpload) continue;
            fileUploads.add(HttpUtils.readUpload(item));
        }
        return fileUploads;
    }

    @Override
    public HttpRequest.FileUpload part(String name) {
        HttpPostRequestDecoder postDecoder = this.getPostDecoder();
        if (postDecoder == null) {
            return null;
        }
        List items = postDecoder.getBodyHttpDatas(name);
        if (items == null) {
            return null;
        }
        int size = items.size();
        for (int i = 0; i < size; ++i) {
            InterfaceHttpData item = (InterfaceHttpData)items.get(i);
            if (item.getHttpDataType() != InterfaceHttpData.HttpDataType.FileUpload) continue;
            return HttpUtils.readUpload(item);
        }
        return null;
    }

    private QueryStringDecoder getDecoder() {
        if (this.decoder == null) {
            String charset = this.charset();
            this.decoder = charset == null ? new QueryStringDecoder(this.uri) : new QueryStringDecoder(this.uri, Charset.forName(charset));
        }
        return this.decoder;
    }

    private HttpPostRequestDecoder getPostDecoder() {
        HttpPostRequestDecoder postDecoder = this.postDecoder;
        if (postDecoder == null) {
            if (this.postParsed) {
                return null;
            }
            if (this.inputStream != null && HttpMethods.supportBody(this.method)) {
                this.postDecoder = postDecoder = HttpUtils.createPostRequestDecoder(this, this.inputStream, this.charset());
            }
            this.postParsed = true;
        }
        return postDecoder;
    }

    @Override
    public <T> T attribute(String name) {
        return (T)this.getAttributes().get(name);
    }

    @Override
    public void removeAttribute(String name) {
        this.getAttributes().remove(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.getAttributes().put(name, value);
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.attributes != null && this.attributes.containsKey(name);
    }

    @Override
    public Collection<String> attributeNames() {
        return this.getAttributes().keySet();
    }

    @Override
    public Map<String, Object> attributes() {
        return this.getAttributes();
    }

    private Map<String, Object> getAttributes() {
        Map<String, Object> attributes = this.attributes;
        if (attributes == null) {
            this.attributes = attributes = new HashMap<String, Object>();
        }
        return attributes;
    }

    @Override
    public InputStream inputStream() {
        return this.inputStream;
    }

    @Override
    public void setInputStream(InputStream is) {
        this.inputStream = is;
        if (HttpMethods.isPost(this.method)) {
            this.postDecoder = null;
            this.postParsed = false;
        }
    }

    public String toString() {
        return "DefaultHttpRequest{" + this.fieldToString() + '}';
    }

    protected final String fieldToString() {
        return "method='" + this.method + '\'' + ", uri='" + this.uri + '\'' + ", contentType='" + this.contentType() + '\'';
    }
}

