/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12.h2;

import java.io.InputStream;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.remoting.http12.h2.Http2InputMessage;

public final class Http2InputMessageFrame
implements Http2InputMessage {
    private final long streamId;
    private final InputStream body;
    private final boolean endStream;

    public Http2InputMessageFrame(InputStream body, boolean endStream) {
        this(-1L, body, endStream);
    }

    public Http2InputMessageFrame(long streamId, InputStream body, boolean endStream) {
        this.streamId = streamId;
        this.body = body;
        this.endStream = endStream;
    }

    @Override
    public InputStream getBody() {
        return this.body;
    }

    @Override
    public String name() {
        return "DATA";
    }

    @Override
    public long id() {
        return this.streamId;
    }

    @Override
    public boolean isEndStream() {
        return this.endStream;
    }

    public String toString() {
        return "Http2InputMessageFrame{body=" + ClassUtils.toShortString(this.body) + ", body=" + this.streamId + ", endStream=" + this.endStream + '}';
    }
}

