/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.dubbo.common.config.Configuration;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.json.JsonUtil;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.rpc.model.FrameworkModel;

public final class HttpJsonUtils {
    private final JsonUtil jsonUtil;

    public HttpJsonUtils(FrameworkModel frameworkModel) {
        JsonUtil jsonUtil;
        Configuration configuration = ConfigurationUtils.getGlobalConfiguration(frameworkModel.defaultApplication());
        String name = configuration.getString("dubbo.protocol.triple.rest.json-framework", null);
        if (name == null) {
            jsonUtil = CollectionUtils.first(frameworkModel.getActivateExtensions(JsonUtil.class));
        } else {
            try {
                jsonUtil = frameworkModel.getExtension(JsonUtil.class, name);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to load json framework: " + name, e);
            }
        }
        this.jsonUtil = Objects.requireNonNull(jsonUtil, "Dubbo unable to find out any json framework");
    }

    public <T> T toJavaObject(String json, Type type) {
        return this.jsonUtil.toJavaObject(json, type);
    }

    public <T> List<T> toJavaList(String json, Class<T> clazz) {
        return this.jsonUtil.toJavaList(json, clazz);
    }

    public String toJson(Object obj) {
        return this.jsonUtil.toJson(obj);
    }

    public String toPrettyJson(Object obj) {
        return this.jsonUtil.toPrettyJson(obj);
    }

    public Object convertObject(Object obj, Type targetType) {
        return this.jsonUtil.convertObject(obj, targetType);
    }

    public Object convertObject(Object obj, Class<?> targetType) {
        return this.jsonUtil.convertObject(obj, targetType);
    }

    public String getString(Map<String, ?> obj, String key) {
        return this.jsonUtil.getString(obj, key);
    }
}

