/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.metadata;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.DubboMetadataServiceV2Triple;
import org.apache.dubbo.metadata.MetadataInfo;
import org.apache.dubbo.metadata.MetadataInfoV2;
import org.apache.dubbo.metadata.MetadataRequest;
import org.apache.dubbo.metadata.util.MetadataServiceVersionUtils;
import org.apache.dubbo.registry.client.ServiceDiscovery;
import org.apache.dubbo.registry.support.RegistryManager;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class MetadataServiceDelegationV2
extends DubboMetadataServiceV2Triple.MetadataServiceV2ImplBase {
    ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(this.getClass());
    private final ApplicationModel applicationModel;
    private final RegistryManager registryManager;
    private URL metadataUrl;
    public static final String VERSION = "2.0.0";

    public MetadataServiceDelegationV2(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
        this.registryManager = RegistryManager.getInstance(applicationModel);
    }

    @Override
    public MetadataInfoV2 getMetadataInfo(MetadataRequest metadataRequestV2) {
        String revision = metadataRequestV2.getRevision();
        MetadataInfo info = null;
        if (StringUtils.isEmpty(revision)) {
            return null;
        }
        for (ServiceDiscovery sd : this.registryManager.getServiceDiscoveries()) {
            info = sd.getLocalMetadata(revision);
            if (info == null || !revision.equals(info.getRevision())) continue;
            return MetadataServiceVersionUtils.toV2(info);
        }
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("1-39", "", "", "metadataV2 not found for revision: " + metadataRequestV2);
        }
        return null;
    }

    public URL getMetadataUrl() {
        return this.metadataUrl;
    }

    public void setMetadataUrl(URL metadataUrl) {
        this.metadataUrl = metadataUrl;
    }
}

