/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.ssl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class Cert {
    private final byte[] keyCertChain;
    private final byte[] privateKey;
    private final byte[] trustCert;
    private final String password;

    public Cert(byte[] keyCertChain, byte[] privateKey, byte[] trustCert) {
        this(keyCertChain, privateKey, trustCert, null);
    }

    public Cert(byte[] keyCertChain, byte[] privateKey, byte[] trustCert, String password) {
        this.keyCertChain = keyCertChain;
        this.privateKey = privateKey;
        this.trustCert = trustCert;
        this.password = password;
    }

    public byte[] getKeyCertChain() {
        return this.keyCertChain;
    }

    public InputStream getKeyCertChainInputStream() {
        return this.keyCertChain != null ? new ByteArrayInputStream(this.keyCertChain) : null;
    }

    public byte[] getPrivateKey() {
        return this.privateKey;
    }

    public InputStream getPrivateKeyInputStream() {
        return this.privateKey != null ? new ByteArrayInputStream(this.privateKey) : null;
    }

    public byte[] getTrustCert() {
        return this.trustCert;
    }

    public InputStream getTrustCertInputStream() {
        return this.trustCert != null ? new ByteArrayInputStream(this.trustCert) : null;
    }

    public String getPassword() {
        return this.password;
    }
}

