/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.auth.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class SignatureUtils {
    private static final String HMAC_SHA256_ALGORITHM = "HmacSHA256";

    public static String sign(String metadata, String key) throws RuntimeException {
        return SignatureUtils.sign(metadata.getBytes(StandardCharsets.UTF_8), key);
    }

    public static String sign(Object[] parameters, String metadata, String key) throws RuntimeException {
        byte[] includeMetadataBytes;
        if (parameters == null) {
            return SignatureUtils.sign(metadata, key);
        }
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i] instanceof Serializable) continue;
            throw new IllegalArgumentException("The parameter [" + i + "] to be signed was not serializable.");
        }
        Object[] includeMetadata = new Object[parameters.length + 1];
        System.arraycopy(parameters, 0, includeMetadata, 0, parameters.length);
        includeMetadata[parameters.length] = metadata;
        try {
            includeMetadataBytes = SignatureUtils.toByteArray(includeMetadata);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to generate HMAC: " + e.getMessage());
        }
        return SignatureUtils.sign(includeMetadataBytes, key);
    }

    private static String sign(byte[] data, String key) throws RuntimeException {
        byte[] rawHmac;
        Mac mac;
        try {
            mac = Mac.getInstance(HMAC_SHA256_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Failed to generate HMAC: no such algorithm exception HmacSHA256");
        }
        SecretKeySpec signingKey = new SecretKeySpec(key.getBytes(), HMAC_SHA256_ALGORITHM);
        try {
            mac.init(signingKey);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Failed to generate HMAC: invalid key exception");
        }
        try {
            rawHmac = mac.doFinal(data);
        }
        catch (IllegalStateException e) {
            throw new RuntimeException("Failed to generate HMAC: " + e.getMessage());
        }
        return Base64.getEncoder().encodeToString(rawHmac);
    }

    private static byte[] toByteArray(Object[] parameters) throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream out = new ObjectOutputStream(bos);){
                out.writeObject(parameters);
                out.flush();
                byArray = bos.toByteArray();
            }
            return byArray;
        }
    }
}

