/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.auth.filter;

import org.apache.dubbo.auth.spi.Authenticator;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.HeaderFilter;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.support.RpcUtils;

@Activate(value={"auth"}, order=-20000)
public class ProviderAuthHeaderFilter
implements HeaderFilter {
    private final FrameworkModel frameworkModel;

    public ProviderAuthHeaderFilter(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
    }

    @Override
    public RpcInvocation invoke(Invoker<?> invoker, RpcInvocation invocation) throws RpcException {
        URL url = invoker.getUrl();
        boolean shouldAuth = url.getParameter("auth", false);
        if (shouldAuth) {
            Authenticator authenticator = this.frameworkModel.getExtensionLoader(Authenticator.class).getExtension(url.getParameter("authenticator", "basic"));
            try {
                authenticator.authenticate(invocation, url);
            }
            catch (Exception e) {
                Class<?> serviceType = invoker.getInterface();
                throw new RpcException(13, "Forbid invoke remote service " + serviceType + " method " + RpcUtils.getMethodName(invocation) + "() from consumer " + invocation.getAttributes().get("tri.remote.address") + " to provider " + RpcContext.getServiceContext().getLocalHost());
            }
            invocation.getAttributes().put("auth.success", Boolean.TRUE);
        }
        return invocation;
    }
}

