/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.support;

import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.utils.ConfigUtils;
import org.apache.dubbo.config.AbstractInterfaceConfig;
import org.apache.dubbo.config.ConfigPostProcessor;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.ServiceConfig;
import org.apache.dubbo.rpc.support.MockInvoker;

@Activate
public class MockConfigPostProcessor
implements ConfigPostProcessor {
    @Override
    public void postProcessReferConfig(ReferenceConfig referenceConfig) {
        MockConfigPostProcessor.checkMock(referenceConfig.getInterfaceClass(), referenceConfig);
    }

    @Override
    public void postProcessServiceConfig(ServiceConfig serviceConfig) {
        MockConfigPostProcessor.checkMock(serviceConfig.getInterfaceClass(), serviceConfig);
    }

    public static void checkMock(Class<?> interfaceClass, AbstractInterfaceConfig config) {
        String mock = config.getMock();
        if (ConfigUtils.isEmpty(mock)) {
            return;
        }
        String normalizedMock = MockInvoker.normalizeMock(mock);
        if (normalizedMock.startsWith("return ")) {
            normalizedMock = normalizedMock.substring("return ".length()).trim();
            try {
                MockInvoker.parseMockValue(normalizedMock);
            }
            catch (Exception e) {
                throw new IllegalStateException("Illegal mock return in <dubbo:service/reference ... mock=\"" + mock + "\" />");
            }
        } else if (normalizedMock.startsWith("throw")) {
            if (ConfigUtils.isNotEmpty(normalizedMock = normalizedMock.substring("throw".length()).trim())) {
                try {
                    MockInvoker.getThrowable(normalizedMock);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Illegal mock throw in <dubbo:service/reference ... mock=\"" + mock + "\" />");
                }
            }
        } else {
            MockInvoker.getMockObject(config.getScopeModel().getExtensionDirector(), normalizedMock, interfaceClass);
        }
    }
}

