/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.h12.http2;

import java.util.Map;
import org.apache.dubbo.remoting.http12.HttpHeaders;
import org.apache.dubbo.remoting.http12.HttpMetadata;
import org.apache.dubbo.remoting.http12.h2.H2StreamChannel;
import org.apache.dubbo.remoting.http12.h2.Http2ServerChannelObserver;
import org.apache.dubbo.remoting.http12.message.HttpMessageCodec;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.ServerStreamObserver;
import org.apache.dubbo.rpc.protocol.tri.TripleProtocol;
import org.apache.dubbo.rpc.protocol.tri.compressor.Compressor;
import org.apache.dubbo.rpc.protocol.tri.h12.AttachmentHolder;
import org.apache.dubbo.rpc.protocol.tri.h12.CompressibleCodec;
import org.apache.dubbo.rpc.protocol.tri.stream.StreamUtils;

public class Http2ServerStreamObserver
extends Http2ServerChannelObserver
implements ServerStreamObserver<Object>,
AttachmentHolder {
    private final FrameworkModel frameworkModel;
    private HttpMessageCodec httpMessageCodec;
    private Map<String, Object> attachments;

    public Http2ServerStreamObserver(FrameworkModel frameworkModel, H2StreamChannel h2StreamChannel) {
        super(h2StreamChannel);
        this.frameworkModel = frameworkModel;
    }

    @Override
    public void setCompression(String compression) {
        CompressibleCodec compressibleCodec = new CompressibleCodec(this.httpMessageCodec);
        compressibleCodec.setCompressor(Compressor.getCompressor(this.frameworkModel, compression));
        super.setHttpMessageCodec(compressibleCodec);
    }

    @Override
    public void setHttpMessageCodec(HttpMessageCodec httpMessageCodec) {
        super.setHttpMessageCodec(httpMessageCodec);
        this.httpMessageCodec = httpMessageCodec;
    }

    @Override
    public void setResponseAttachments(Map<String, Object> attachments) {
        this.attachments = attachments;
    }

    @Override
    public Map<String, Object> getResponseAttachments() {
        return this.attachments;
    }

    @Override
    protected HttpMetadata encodeTrailers(Throwable throwable) {
        HttpMetadata httpMetadata = super.encodeTrailers(throwable);
        HttpHeaders headers = httpMetadata.headers();
        StreamUtils.convertAttachment(headers, this.attachments, TripleProtocol.CONVERT_NO_LOWER_HEADER);
        return httpMetadata;
    }
}

