/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.h12.http2;

import java.util.concurrent.Executor;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.threadpool.manager.ExecutorRepository;
import org.apache.dubbo.common.threadpool.serial.SerializingExecutor;
import org.apache.dubbo.remoting.http12.exception.HttpStatusException;
import org.apache.dubbo.remoting.http12.h2.H2StreamChannel;
import org.apache.dubbo.remoting.http12.h2.Http2Header;
import org.apache.dubbo.remoting.http12.h2.Http2InputMessage;
import org.apache.dubbo.remoting.http12.h2.Http2ServerChannelObserver;
import org.apache.dubbo.remoting.http12.h2.Http2TransportListener;
import org.apache.dubbo.remoting.http12.message.DefaultListeningDecoder;
import org.apache.dubbo.remoting.http12.message.JsonCodec;
import org.apache.dubbo.remoting.http12.message.ListeningDecoder;
import org.apache.dubbo.remoting.http12.message.MethodMetadata;
import org.apache.dubbo.remoting.http12.message.NoOpStreamingDecoder;
import org.apache.dubbo.remoting.http12.message.StreamingDecoder;
import org.apache.dubbo.rpc.CancellationContext;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.executor.ExecutorSupport;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.protocol.tri.ReflectionPackableMethod;
import org.apache.dubbo.rpc.protocol.tri.h12.AbstractServerTransportListener;
import org.apache.dubbo.rpc.protocol.tri.h12.BiStreamServerCallListener;
import org.apache.dubbo.rpc.protocol.tri.h12.HttpMessageListener;
import org.apache.dubbo.rpc.protocol.tri.h12.ServerCallListener;
import org.apache.dubbo.rpc.protocol.tri.h12.ServerStreamServerCallListener;
import org.apache.dubbo.rpc.protocol.tri.h12.UnaryServerCallListener;
import org.apache.dubbo.rpc.protocol.tri.h12.grpc.StreamingHttpMessageListener;
import org.apache.dubbo.rpc.protocol.tri.h12.http2.Http2ServerCallToObserverAdapter;

public class GenericHttp2ServerTransportListener
extends AbstractServerTransportListener<Http2Header, Http2InputMessage>
implements Http2TransportListener {
    private final Http2ServerChannelObserver serverChannelObserver;
    private final H2StreamChannel h2StreamChannel;
    private final ExecutorSupport executorSupport;
    private final StreamingDecoder streamingDecoder;
    private ServerCallListener serverCallListener;

    public GenericHttp2ServerTransportListener(H2StreamChannel h2StreamChannel, URL url, FrameworkModel frameworkModel) {
        super(frameworkModel, url, h2StreamChannel);
        this.h2StreamChannel = h2StreamChannel;
        this.executorSupport = ExecutorRepository.getInstance(url.getOrDefaultApplicationModel()).getExecutorSupport(url);
        this.streamingDecoder = this.newStreamingDecoder();
        this.serverChannelObserver = new Http2ServerCallToObserverAdapter(frameworkModel, h2StreamChannel);
        this.serverChannelObserver.setHttpMessageCodec(JsonCodec.INSTANCE);
        this.serverChannelObserver.setStreamingDecoder(this.streamingDecoder);
    }

    @Override
    protected Executor initializeExecutor(Http2Header metadata) {
        Executor executor = this.executorSupport.getExecutor(metadata);
        return new SerializingExecutor(executor);
    }

    private ServerCallListener startListener(RpcInvocation invocation, MethodDescriptor methodDescriptor, Invoker<?> invoker) {
        Http2ServerChannelObserver responseObserver = this.getServerChannelObserver();
        CancellationContext cancellationContext = RpcContext.getCancellationContext();
        responseObserver.setCancellationContext(cancellationContext);
        switch (methodDescriptor.getRpcType()) {
            case UNARY: {
                Http2Header httpMetadata = (Http2Header)this.getHttpMetadata();
                boolean hasStub = this.getPathResolver().hasNativeStub(httpMetadata.path());
                boolean applyCustomizeException = false;
                if (!hasStub) {
                    applyCustomizeException = ReflectionPackableMethod.needWrap(methodDescriptor, this.getMethodMetadata().getActualRequestTypes(), this.getMethodMetadata().getActualResponseType());
                }
                UnaryServerCallListener unaryServerCallListener = this.startUnary(invocation, invoker, responseObserver);
                unaryServerCallListener.setApplyCustomizeException(applyCustomizeException);
                return unaryServerCallListener;
            }
            case SERVER_STREAM: {
                return this.startServerStreaming(invocation, invoker, responseObserver);
            }
            case BI_STREAM: 
            case CLIENT_STREAM: {
                return this.startBiStreaming(invocation, invoker, responseObserver);
            }
        }
        throw new IllegalStateException("Can not reach here");
    }

    public Http2ServerChannelObserver getServerChannelObserver() {
        return this.serverChannelObserver;
    }

    @Override
    public void cancelByRemote(long errorCode) {
        this.serverChannelObserver.cancel(new HttpStatusException((int)errorCode));
        this.serverCallListener.onCancel(errorCode);
    }

    protected StreamingDecoder newStreamingDecoder() {
        return new NoOpStreamingDecoder();
    }

    @Override
    protected void doOnMetadata(Http2Header metadata) {
        if (metadata.isEndStream()) {
            return;
        }
        super.doOnMetadata(metadata);
    }

    @Override
    protected HttpMessageListener newHttpMessageListener() {
        RpcInvocation rpcInvocation;
        MethodMetadata methodMetadata;
        Object httpMetadata = this.getHttpMetadata();
        String path = httpMetadata.path();
        String[] parts = path.split("/");
        String originalMethodName = parts[2];
        MethodDescriptor methodDescriptor = this.getMethodDescriptor();
        if (methodDescriptor == null) {
            methodDescriptor = GenericHttp2ServerTransportListener.findMethodDescriptor(this.getServiceDescriptor(), originalMethodName, this.isHasStub());
            this.setMethodDescriptor(methodDescriptor);
        }
        if ((methodMetadata = this.getMethodMetadata()) == null) {
            methodMetadata = MethodMetadata.fromMethodDescriptor(this.getMethodDescriptor());
            this.setMethodMetadata(methodMetadata);
        }
        if ((rpcInvocation = this.getRpcInvocation()) == null) {
            this.setRpcInvocation(this.buildRpcInvocation(this.getInvoker(), this.getServiceDescriptor(), methodDescriptor));
        }
        this.initializeServerCallListener();
        DefaultListeningDecoder defaultListeningDecoder = new DefaultListeningDecoder(this.getHttpMessageCodec(), this.getMethodMetadata().getActualRequestTypes());
        defaultListeningDecoder.setListener(new Http2StreamingDecodeListener(this.serverCallListener));
        this.streamingDecoder.setFragmentListener(new StreamingDecoder.DefaultFragmentListener(defaultListeningDecoder));
        this.getServerChannelObserver().setStreamingDecoder(this.streamingDecoder);
        return new StreamingHttpMessageListener(this.streamingDecoder);
    }

    @Override
    protected void onMetadataCompletion(Http2Header metadata) {
        super.onMetadataCompletion(metadata);
        this.serverChannelObserver.setHttpMessageCodec(this.getHttpMessageCodec());
        this.serverChannelObserver.request(1);
    }

    @Override
    protected void onDataCompletion(Http2InputMessage message) {
        if (message.isEndStream()) {
            this.serverCallListener.onComplete();
        }
    }

    @Override
    protected void onError(Throwable throwable) {
        this.serverChannelObserver.onError(throwable);
    }

    protected StreamingDecoder getStreamingDecoder() {
        return this.streamingDecoder;
    }

    private void initializeServerCallListener() {
        if (this.serverCallListener == null) {
            this.serverCallListener = this.startListener(this.getRpcInvocation(), this.getMethodDescriptor(), this.getInvoker());
        }
    }

    private UnaryServerCallListener startUnary(RpcInvocation invocation, Invoker<?> invoker, Http2ServerChannelObserver responseObserver) {
        return new UnaryServerCallListener(invocation, invoker, responseObserver);
    }

    private ServerStreamServerCallListener startServerStreaming(RpcInvocation invocation, Invoker<?> invoker, Http2ServerChannelObserver responseObserver) {
        return new ServerStreamServerCallListener(invocation, invoker, responseObserver);
    }

    private BiStreamServerCallListener startBiStreaming(RpcInvocation invocation, Invoker<?> invoker, Http2ServerChannelObserver responseObserver) {
        return new BiStreamServerCallListener(invocation, invoker, responseObserver);
    }

    protected ServerCallListener getServerCallListener() {
        return this.serverCallListener;
    }

    private static class Http2StreamingDecodeListener
    implements ListeningDecoder.Listener {
        private final ServerCallListener serverCallListener;

        private Http2StreamingDecodeListener(ServerCallListener serverCallListener) {
            this.serverCallListener = serverCallListener;
        }

        @Override
        public void onMessage(Object message) {
            this.serverCallListener.onMessage(message);
        }

        @Override
        public void onClose() {
            this.serverCallListener.onComplete();
        }
    }
}

