/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.h12.grpc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.serialize.MultipleSerialization;
import org.apache.dubbo.remoting.http12.exception.DecodeException;
import org.apache.dubbo.remoting.http12.exception.EncodeException;
import org.apache.dubbo.remoting.http12.message.HttpMessageCodec;
import org.apache.dubbo.remoting.http12.message.MediaType;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.TripleCustomerProtocolWapper;

public class WrapperHttpMessageCodec
implements HttpMessageCodec {
    private static final MediaType MEDIA_TYPE = new MediaType("application", "triple+wrapper");
    private static final String DEFAULT_SERIALIZE_TYPE = "fastjson2";
    private final MultipleSerialization serialization;
    private final URL url;
    private Class<?>[] encodeTypes;
    private Class<?>[] decodeTypes;
    private String serializeType = "fastjson2";

    public WrapperHttpMessageCodec(URL url, FrameworkModel frameworkModel) {
        this.url = url;
        this.serialization = frameworkModel.getExtensionLoader(MultipleSerialization.class).getExtension(url.getParameter("serialize.multiple", "default"));
    }

    public void setSerializeType(String serializeType) {
        this.serializeType = serializeType;
    }

    public void setEncodeTypes(Class<?>[] encodeTypes) {
        this.encodeTypes = encodeTypes;
    }

    public void setDecodeTypes(Class<?>[] decodeTypes) {
        this.decodeTypes = decodeTypes;
    }

    @Override
    public void encode(OutputStream outputStream, Object data) throws EncodeException {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            this.serialization.serialize(this.url, this.serializeType, this.encodeTypes[0], data, bos);
            byte[] encoded = TripleCustomerProtocolWapper.TripleResponseWrapper.Builder.newBuilder().setSerializeType(this.serializeType).setType(this.encodeTypes[0].getName()).setData(bos.toByteArray()).build().toByteArray();
            WrapperHttpMessageCodec.writeLength(outputStream, encoded.length);
            outputStream.write(encoded);
        }
        catch (IOException e) {
            throw new EncodeException(e);
        }
    }

    @Override
    public void encode(OutputStream outputStream, Object[] data) throws EncodeException {
    }

    @Override
    public Object decode(InputStream inputStream, Class<?> targetType) throws DecodeException {
        Object[] decode = this.decode(inputStream, new Class[]{targetType});
        if (decode == null || decode.length == 0) {
            return null;
        }
        return decode[0];
    }

    @Override
    public Object[] decode(InputStream inputStream, Class<?>[] targetTypes) throws DecodeException {
        try {
            int len;
            byte[] data = new byte[4096];
            ByteArrayOutputStream bos = new ByteArrayOutputStream(4096);
            while ((len = inputStream.read(data)) != -1) {
                bos.write(data, 0, len);
            }
            TripleCustomerProtocolWapper.TripleRequestWrapper wrapper = TripleCustomerProtocolWapper.TripleRequestWrapper.parseFrom(bos.toByteArray());
            this.setSerializeType(wrapper.getSerializeType());
            Object[] ret = new Object[wrapper.getArgs().size()];
            for (int i = 0; i < wrapper.getArgs().size(); ++i) {
                ByteArrayInputStream in = new ByteArrayInputStream(wrapper.getArgs().get(i));
                try {
                    ret[i] = this.serialization.deserialize(this.url, wrapper.getSerializeType(), targetTypes[i], in);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new DecodeException(e);
                }
            }
            return ret;
        }
        catch (IOException e) {
            throw new DecodeException(e);
        }
    }

    @Override
    public MediaType contentType() {
        return MEDIA_TYPE;
    }

    private static void writeLength(OutputStream outputStream, int length) throws IOException {
        outputStream.write(length >> 24 & 0xFF);
        outputStream.write(length >> 16 & 0xFF);
        outputStream.write(length >> 8 & 0xFF);
        outputStream.write(length & 0xFF);
    }
}

