/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.h12.grpc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.remoting.http12.HttpHeaders;
import org.apache.dubbo.remoting.http12.exception.DecodeException;
import org.apache.dubbo.remoting.http12.exception.UnimplementedException;
import org.apache.dubbo.remoting.http12.h2.H2StreamChannel;
import org.apache.dubbo.remoting.http12.h2.Http2Header;
import org.apache.dubbo.remoting.http12.h2.Http2TransportListener;
import org.apache.dubbo.remoting.http12.message.MethodMetadata;
import org.apache.dubbo.remoting.http12.message.StreamingDecoder;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.TriRpcStatus;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.model.ServiceDescriptor;
import org.apache.dubbo.rpc.protocol.tri.TripleCustomerProtocolWapper;
import org.apache.dubbo.rpc.protocol.tri.call.AbstractServerCall;
import org.apache.dubbo.rpc.protocol.tri.compressor.DeCompressor;
import org.apache.dubbo.rpc.protocol.tri.h12.HttpMessageListener;
import org.apache.dubbo.rpc.protocol.tri.h12.grpc.GrpcCompositeCodec;
import org.apache.dubbo.rpc.protocol.tri.h12.grpc.GrpcHeaderNames;
import org.apache.dubbo.rpc.protocol.tri.h12.grpc.GrpcStreamingDecoder;
import org.apache.dubbo.rpc.protocol.tri.h12.grpc.GrpcUtils;
import org.apache.dubbo.rpc.protocol.tri.h12.http2.GenericHttp2ServerTransportListener;

public class GrpcHttp2ServerTransportListener
extends GenericHttp2ServerTransportListener
implements Http2TransportListener {
    private static final ErrorTypeAwareLogger LOGGER = LoggerFactory.getErrorTypeAwareLogger(AbstractServerCall.class);

    public GrpcHttp2ServerTransportListener(H2StreamChannel h2StreamChannel, URL url, FrameworkModel frameworkModel) {
        super(h2StreamChannel, url, frameworkModel);
        this.initialize();
    }

    private void initialize() {
        this.getServerChannelObserver().setTrailersCustomizer(this::grpcTrailersCustomize);
    }

    private void grpcTrailersCustomize(HttpHeaders httpHeaders, Throwable throwable) {
        httpHeaders.set(GrpcHeaderNames.GRPC_STATUS.getName(), "0");
        if (throwable != null) {
            httpHeaders.set(GrpcHeaderNames.GRPC_STATUS.getName(), GrpcHttp2ServerTransportListener.httpStatusToGrpcStatus(throwable));
            httpHeaders.set(GrpcHeaderNames.GRPC_MESSAGE.getName(), throwable.getMessage());
        }
    }

    private static String httpStatusToGrpcStatus(Throwable throwable) {
        return String.valueOf(TriRpcStatus.INTERNAL.code.code);
    }

    @Override
    protected RpcInvocation buildRpcInvocation(Invoker<?> invoker, ServiceDescriptor serviceDescriptor, MethodDescriptor methodDescriptor) {
        RpcInvocation rpcInvocation = super.buildRpcInvocation(invoker, serviceDescriptor, methodDescriptor);
        HttpHeaders headers = ((Http2Header)this.getHttpMetadata()).headers();
        String timeoutString = headers.getFirst(GrpcHeaderNames.GRPC_TIMEOUT.getName());
        try {
            if (Objects.nonNull(timeoutString)) {
                Long timeout = GrpcUtils.parseTimeoutToMills(timeoutString);
                rpcInvocation.put("timeout", timeout);
            }
        }
        catch (Throwable t) {
            LOGGER.warn("4-9", "", "", String.format("Failed to parse request timeout set from:%s, service=%s method=%s", timeoutString, serviceDescriptor.getInterfaceName(), this.getMethodDescriptor().getMethodName()));
        }
        return rpcInvocation;
    }

    @Override
    protected StreamingDecoder newStreamingDecoder() {
        return new GrpcStreamingDecoder();
    }

    @Override
    protected HttpMessageListener newHttpMessageListener() {
        Http2Header httpMetadata = (Http2Header)this.getHttpMetadata();
        boolean hasStub = this.getPathResolver().hasNativeStub(httpMetadata.path());
        if (hasStub) {
            return GrpcHttp2ServerTransportListener.super.newHttpMessageListener();
        }
        return new LazyFindMethodListener();
    }

    @Override
    protected void onMetadataCompletion(Http2Header metadata) {
        super.onMetadataCompletion(metadata);
        this.processGrpcHeaders(metadata);
    }

    private void processGrpcHeaders(Http2Header metadata) {
        String messageEncoding = metadata.headers().getFirst(GrpcHeaderNames.GRPC_ENCODING.getName());
        if (null != messageEncoding && !"identity".equals(messageEncoding)) {
            DeCompressor compressor = DeCompressor.getCompressor(this.getFrameworkModel(), messageEncoding);
            if (null == compressor) {
                throw new UnimplementedException(GrpcHeaderNames.GRPC_ENCODING.getName() + " '" + messageEncoding + "'");
            }
            this.getStreamingDecoder().setDeCompressor(compressor);
        }
    }

    @Override
    protected GrpcStreamingDecoder getStreamingDecoder() {
        return (GrpcStreamingDecoder)super.getStreamingDecoder();
    }

    private class LazyFindMethodListener
    implements HttpMessageListener {
        private final StreamingDecoder streamingDecoder = new GrpcStreamingDecoder();

        private LazyFindMethodListener() {
            this.streamingDecoder.setFragmentListener(new DetermineMethodDescriptorListener());
            this.streamingDecoder.request(Integer.MAX_VALUE);
        }

        @Override
        public void onMessage(InputStream inputStream) {
            this.streamingDecoder.decode(inputStream);
        }
    }

    private class DetermineMethodDescriptorListener
    implements StreamingDecoder.FragmentListener {
        private DetermineMethodDescriptorListener() {
        }

        @Override
        public void onFragmentMessage(InputStream rawMessage) {
        }

        @Override
        public void onClose() {
            GrpcHttp2ServerTransportListener.this.getStreamingDecoder().close();
        }

        @Override
        public void onFragmentMessage(InputStream dataHeader, InputStream rawMessage) {
            try {
                ByteArrayOutputStream merge = new ByteArrayOutputStream(dataHeader.available() + rawMessage.available());
                this.transferToOutputStream(merge, dataHeader);
                ByteArrayOutputStream bos = new ByteArrayOutputStream(rawMessage.available());
                this.transferToOutputStream(bos, rawMessage);
                byte[] data = bos.toByteArray();
                MethodDescriptor methodDescriptor = GrpcHttp2ServerTransportListener.this.getMethodDescriptor();
                if (methodDescriptor == null) {
                    Http2Header httpMetadata = (Http2Header)GrpcHttp2ServerTransportListener.this.getHttpMetadata();
                    String path = httpMetadata.path();
                    String[] parts = path.split("/");
                    String originalMethodName = parts[2];
                    methodDescriptor = GrpcHttp2ServerTransportListener.findReflectionMethodDescriptor(GrpcHttp2ServerTransportListener.this.getServiceDescriptor(), originalMethodName);
                    if (methodDescriptor == null) {
                        List<MethodDescriptor> methodDescriptors = GrpcHttp2ServerTransportListener.this.getServiceDescriptor().getMethods(originalMethodName);
                        TripleCustomerProtocolWapper.TripleRequestWrapper request = TripleCustomerProtocolWapper.TripleRequestWrapper.parseFrom(data);
                        Object[] paramTypes = request.getArgTypes().toArray(new String[request.getArgs().size()]);
                        for (MethodDescriptor descriptor : methodDescriptors) {
                            if (!Arrays.equals(descriptor.getCompatibleParamSignatures(), paramTypes)) continue;
                            methodDescriptor = descriptor;
                            break;
                        }
                        if (methodDescriptor == null) {
                            throw new UnimplementedException("method:" + originalMethodName);
                        }
                    }
                    GrpcHttp2ServerTransportListener.this.setMethodDescriptor(methodDescriptor);
                    GrpcHttp2ServerTransportListener.this.setMethodMetadata(MethodMetadata.fromMethodDescriptor(methodDescriptor));
                    GrpcHttp2ServerTransportListener.this.setRpcInvocation(GrpcHttp2ServerTransportListener.this.buildRpcInvocation(GrpcHttp2ServerTransportListener.this.getInvoker(), GrpcHttp2ServerTransportListener.this.getServiceDescriptor(), methodDescriptor));
                    HttpMessageListener httpMessageListener = GrpcHttp2ServerTransportListener.super.newHttpMessageListener();
                    GrpcCompositeCodec grpcCompositeCodec = (GrpcCompositeCodec)GrpcHttp2ServerTransportListener.this.getHttpMessageCodec();
                    grpcCompositeCodec.setEncodeTypes(new Class[]{GrpcHttp2ServerTransportListener.this.getMethodMetadata().getActualResponseType()});
                    grpcCompositeCodec.setDecodeTypes(GrpcHttp2ServerTransportListener.this.getMethodMetadata().getActualRequestTypes());
                    GrpcHttp2ServerTransportListener.this.setHttpMessageListener(httpMessageListener);
                }
                this.transferToOutputStream(merge, new ByteArrayInputStream(data));
                GrpcHttp2ServerTransportListener.this.getHttpMessageListener().onMessage(new ByteArrayInputStream(merge.toByteArray()));
            }
            catch (IOException e) {
                throw new DecodeException(e);
            }
        }

        private void transferToOutputStream(OutputStream out, InputStream inputStream) throws IOException {
            int len;
            byte[] bytes = new byte[1024];
            while ((len = inputStream.read(bytes)) != -1) {
                out.write(bytes, 0, len);
            }
        }
    }
}

