/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.h12.grpc;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.remoting.http12.message.HttpMessageCodec;
import org.apache.dubbo.remoting.http12.message.HttpMessageCodecFactory;
import org.apache.dubbo.remoting.http12.message.MediaType;
import org.apache.dubbo.remoting.utils.UrlUtils;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.h12.grpc.GrpcCompositeCodec;
import org.apache.dubbo.rpc.protocol.tri.h12.grpc.ProtobufHttpMessageCodec;
import org.apache.dubbo.rpc.protocol.tri.h12.grpc.WrapperHttpMessageCodec;

@Activate
public class GrpcCompositeCodecFactory
implements HttpMessageCodecFactory {
    private static final MediaType MEDIA_TYPE = new MediaType("application", "grpc");

    @Override
    public HttpMessageCodec createCodec(URL url, FrameworkModel frameworkModel) {
        String serializeName = UrlUtils.serializationOrDefault(url);
        WrapperHttpMessageCodec wrapperHttpMessageCodec = new WrapperHttpMessageCodec(url, frameworkModel);
        wrapperHttpMessageCodec.setSerializeType(serializeName);
        ProtobufHttpMessageCodec protobufHttpMessageCodec = new ProtobufHttpMessageCodec();
        return new GrpcCompositeCodec(protobufHttpMessageCodec, wrapperHttpMessageCodec);
    }

    @Override
    public MediaType contentType() {
        return MEDIA_TYPE;
    }

    @Override
    public boolean support(String contentType) {
        return contentType.startsWith(MEDIA_TYPE.getName());
    }
}

