/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.h12;

import io.netty.handler.codec.http2.Http2CodecUtil;
import org.apache.dubbo.remoting.api.ProtocolDetector;
import org.apache.dubbo.remoting.buffer.ByteBufferBackedChannelBuffer;
import org.apache.dubbo.remoting.buffer.ChannelBuffer;
import org.apache.dubbo.remoting.buffer.ChannelBuffers;

public class TripleProtocolDetector
implements ProtocolDetector {
    public static final String HTTP_VERSION = "HTTP_VERSION";
    private final ChannelBuffer clientPrefaceString = new ByteBufferBackedChannelBuffer(Http2CodecUtil.connectionPrefaceBuf().nioBuffer());

    @Override
    public ProtocolDetector.Result detect(ChannelBuffer in) {
        if (in.readableBytes() < 2) {
            return ProtocolDetector.Result.needMoreData();
        }
        byte[] magics = new byte[5];
        in.getBytes(in.readerIndex(), magics, 0, 5);
        if (TripleProtocolDetector.isHttp(magics)) {
            ProtocolDetector.Result recognized = ProtocolDetector.Result.recognized();
            recognized.setAttribute(HTTP_VERSION, HttpVersion.HTTP1.getVersion());
            return recognized;
        }
        in.resetReaderIndex();
        int prefaceLen = this.clientPrefaceString.readableBytes();
        int bytesRead = Math.min(in.readableBytes(), prefaceLen);
        if (bytesRead == 0 || !ChannelBuffers.prefixEquals(in, this.clientPrefaceString, bytesRead)) {
            return ProtocolDetector.Result.unrecognized();
        }
        if (bytesRead == prefaceLen) {
            ProtocolDetector.Result recognized = ProtocolDetector.Result.recognized();
            recognized.setAttribute(HTTP_VERSION, HttpVersion.HTTP2.getVersion());
            return recognized;
        }
        return ProtocolDetector.Result.needMoreData();
    }

    private static boolean isHttp(byte[] magic) {
        if (magic[0] == 71 && magic[1] == 69 && magic[2] == 84) {
            return true;
        }
        return magic[0] == 80 && magic[1] == 79 && magic[2] == 83 && magic[3] == 84;
    }

    public static enum HttpVersion {
        HTTP1("http1"),
        HTTP2("http2");

        private final String version;

        private HttpVersion(String version) {
            this.version = version;
        }

        public String getVersion() {
            return this.version;
        }
    }
}

