/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.h12;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.dubbo.remoting.http12.exception.DecodeException;
import org.apache.dubbo.remoting.http12.exception.EncodeException;
import org.apache.dubbo.remoting.http12.message.HttpMessageCodec;
import org.apache.dubbo.remoting.http12.message.MediaType;
import org.apache.dubbo.rpc.protocol.tri.compressor.Compressor;

public class CompressibleCodec
implements HttpMessageCodec {
    private final HttpMessageCodec delegate;
    private Compressor compressor = Compressor.NONE;

    public CompressibleCodec(HttpMessageCodec delegate) {
        this.delegate = delegate;
    }

    public void setCompressor(Compressor compressor) {
        this.compressor = compressor;
    }

    @Override
    public void encode(OutputStream outputStream, Object data) throws EncodeException {
        this.delegate.encode(this.compressor.decorate(outputStream), data);
    }

    @Override
    public Object decode(InputStream inputStream, Class<?> targetType) throws DecodeException {
        return this.delegate.decode(inputStream, targetType);
    }

    @Override
    public void encode(OutputStream outputStream, Object[] data) throws EncodeException {
        this.delegate.encode(outputStream, data);
    }

    @Override
    public Object[] decode(InputStream inputStream, Class<?>[] targetTypes) throws DecodeException {
        return this.delegate.decode(inputStream, targetTypes);
    }

    @Override
    public boolean support(String contentType) {
        return this.delegate.support(contentType);
    }

    @Override
    public MediaType contentType() {
        return this.delegate.contentType();
    }
}

