/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.h12;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.JsonUtils;
import org.apache.dubbo.remoting.http12.HttpChannel;
import org.apache.dubbo.remoting.http12.HttpHeaderNames;
import org.apache.dubbo.remoting.http12.HttpHeaders;
import org.apache.dubbo.remoting.http12.HttpInputMessage;
import org.apache.dubbo.remoting.http12.HttpStatus;
import org.apache.dubbo.remoting.http12.HttpTransportListener;
import org.apache.dubbo.remoting.http12.RequestMetadata;
import org.apache.dubbo.remoting.http12.exception.HttpStatusException;
import org.apache.dubbo.remoting.http12.exception.IllegalPathException;
import org.apache.dubbo.remoting.http12.exception.UnimplementedException;
import org.apache.dubbo.remoting.http12.exception.UnsupportedMediaTypeException;
import org.apache.dubbo.remoting.http12.message.HttpMessageCodec;
import org.apache.dubbo.remoting.http12.message.HttpMessageCodecFactory;
import org.apache.dubbo.remoting.http12.message.MethodMetadata;
import org.apache.dubbo.rpc.HeaderFilter;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.PathResolver;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.TriRpcStatus;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.model.ProviderModel;
import org.apache.dubbo.rpc.model.ServiceDescriptor;
import org.apache.dubbo.rpc.protocol.tri.TripleHeaderEnum;
import org.apache.dubbo.rpc.protocol.tri.TripleProtocol;
import org.apache.dubbo.rpc.protocol.tri.h12.HttpMessageListener;
import org.apache.dubbo.rpc.protocol.tri.stream.StreamUtils;
import org.apache.dubbo.rpc.service.ServiceDescriptorInternalCache;
import org.apache.dubbo.rpc.stub.StubSuppliers;

public abstract class AbstractServerTransportListener<HEADER extends RequestMetadata, MESSAGE extends HttpInputMessage>
implements HttpTransportListener<HEADER, MESSAGE> {
    private static final ErrorTypeAwareLogger LOGGER = LoggerFactory.getErrorTypeAwareLogger(AbstractServerTransportListener.class);
    private final PathResolver pathResolver;
    private final FrameworkModel frameworkModel;
    private final URL url;
    private final HttpChannel httpChannel;
    private final List<HeaderFilter> headerFilters;
    private HttpMessageCodec httpMessageCodec;
    private Invoker<?> invoker;
    private ServiceDescriptor serviceDescriptor;
    private MethodDescriptor methodDescriptor;
    private RpcInvocation rpcInvocation;
    private MethodMetadata methodMetadata;
    private HEADER httpMetadata;
    private Executor executor;
    private boolean hasStub;
    private HttpMessageListener httpMessageListener;

    public AbstractServerTransportListener(FrameworkModel frameworkModel, URL url, HttpChannel httpChannel) {
        this.frameworkModel = frameworkModel;
        this.url = url;
        this.httpChannel = httpChannel;
        this.pathResolver = frameworkModel.getExtensionLoader(PathResolver.class).getDefaultExtension();
        this.headerFilters = frameworkModel.getExtensionLoader(HeaderFilter.class).getActivateExtension(url, "header.filter");
    }

    protected Executor initializeExecutor(HEADER metadata) {
        return Runnable::run;
    }

    @Override
    public void onMetadata(HEADER metadata) {
        try {
            this.executor = this.initializeExecutor(metadata);
        }
        catch (Throwable throwable) {
            LOGGER.error("initialize executor fail.", throwable);
            this.onError(throwable);
            return;
        }
        if (this.executor == null) {
            LOGGER.error("executor must be not null.");
            this.onError(new NullPointerException("initializeExecutor return null"));
            return;
        }
        this.executor.execute(() -> {
            try {
                this.doOnMetadata(metadata);
            }
            catch (Throwable throwable) {
                LOGGER.error("server internal error", throwable);
                this.onError(throwable);
            }
        });
    }

    protected void doOnMetadata(HEADER metadata) {
        this.onPrepareMetadata(metadata);
        this.httpMetadata = metadata;
        String path = metadata.path();
        HttpHeaders headers = metadata.headers();
        String contentType = headers.getFirst(HttpHeaderNames.CONTENT_TYPE.getName());
        if (contentType == null) {
            throw new UnsupportedMediaTypeException("'" + HttpHeaderNames.CONTENT_TYPE.getName() + "' must be not null.");
        }
        String[] parts = path.split("/");
        if (parts.length != 3) {
            throw new IllegalPathException(path);
        }
        String serviceName = parts[1];
        this.hasStub = this.pathResolver.hasNativeStub(path);
        this.invoker = this.getInvoker(metadata, serviceName);
        if (this.invoker == null) {
            throw new UnimplementedException(serviceName);
        }
        HttpMessageCodec httpMessageCodec = this.determineHttpMessageCodec(contentType);
        if (httpMessageCodec == null) {
            throw new UnsupportedMediaTypeException(contentType);
        }
        this.httpMessageCodec = httpMessageCodec;
        this.setServiceDescriptor(AbstractServerTransportListener.findServiceDescriptor(this.invoker, serviceName, this.hasStub));
        this.setHttpMessageListener(this.newHttpMessageListener());
        this.onMetadataCompletion(metadata);
    }

    protected abstract HttpMessageListener newHttpMessageListener();

    @Override
    public void onData(MESSAGE message) {
        this.executor.execute(() -> {
            try {
                this.doOnData(message);
            }
            catch (Throwable e) {
                LOGGER.error("server internal error", e);
                this.onError(e);
            }
        });
    }

    protected void doOnData(MESSAGE message) {
        this.onPrepareData(message);
        InputStream body = message.getBody();
        this.httpMessageListener.onMessage(body);
        this.onDataCompletion(message);
    }

    protected void onPrepareMetadata(HEADER header) {
    }

    protected void onMetadataCompletion(HEADER metadata) {
    }

    protected void onPrepareData(MESSAGE message) {
    }

    protected void onDataCompletion(MESSAGE message) {
    }

    protected void onError(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof InvocationTargetException) {
            Throwable targetException = ((InvocationTargetException)throwable).getTargetException();
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            if (targetException instanceof Error) {
                throw (Error)targetException;
            }
        }
        throw new HttpStatusException(HttpStatus.INTERNAL_SERVER_ERROR.getCode(), throwable);
    }

    private Invoker<?> getInvoker(HEADER metadata, String serviceName) {
        HttpHeaders headers = metadata.headers();
        String version = headers.containsKey(TripleHeaderEnum.SERVICE_VERSION.getHeader()) ? headers.get(TripleHeaderEnum.SERVICE_VERSION.getHeader()).toString() : null;
        String group = headers.containsKey(TripleHeaderEnum.SERVICE_GROUP.getHeader()) ? headers.get(TripleHeaderEnum.SERVICE_GROUP.getHeader()).toString() : null;
        String key = URL.buildKey(serviceName, group, version);
        Invoker<?> invoker = this.pathResolver.resolve(key);
        if (invoker == null && TripleProtocol.RESOLVE_FALLBACK_TO_DEFAULT) {
            invoker = this.pathResolver.resolve(URL.buildKey(serviceName, group, "1.0.0"));
        }
        if (invoker == null && TripleProtocol.RESOLVE_FALLBACK_TO_DEFAULT) {
            invoker = this.pathResolver.resolve(serviceName);
        }
        return invoker;
    }

    protected HttpMessageCodec determineHttpMessageCodec(String contentType) {
        for (HttpMessageCodecFactory httpMessageCodecFactory : this.frameworkModel.getExtensionLoader(HttpMessageCodecFactory.class).getActivateExtensions()) {
            if (!httpMessageCodecFactory.support(contentType)) continue;
            return httpMessageCodecFactory.createCodec(this.invoker.getUrl(), this.frameworkModel);
        }
        return null;
    }

    private static ServiceDescriptor findServiceDescriptor(Invoker<?> invoker, String serviceName, boolean hasStub) throws UnimplementedException {
        ServiceDescriptor result = hasStub ? AbstractServerTransportListener.getStubServiceDescriptor(invoker.getUrl(), serviceName) : AbstractServerTransportListener.getReflectionServiceDescriptor(invoker.getUrl());
        if (result == null) {
            throw new UnimplementedException("service:" + serviceName);
        }
        return result;
    }

    protected static MethodDescriptor findMethodDescriptor(ServiceDescriptor serviceDescriptor, String originalMethodName, boolean hasStub) throws UnimplementedException {
        MethodDescriptor result = hasStub ? serviceDescriptor.getMethods(originalMethodName).get(0) : AbstractServerTransportListener.findReflectionMethodDescriptor(serviceDescriptor, originalMethodName);
        return result;
    }

    protected RpcInvocation buildRpcInvocation(Invoker<?> invoker, ServiceDescriptor serviceDescriptor, MethodDescriptor methodDescriptor) {
        URL url = invoker.getUrl();
        RpcInvocation inv = new RpcInvocation(url.getServiceModel(), methodDescriptor.getMethodName(), serviceDescriptor.getInterfaceName(), url.getProtocolServiceKey(), methodDescriptor.getParameterClasses(), new Object[0]);
        inv.setTargetServiceUniqueName(url.getServiceKey());
        inv.setReturnTypes(methodDescriptor.getReturnTypes());
        Map<String, String> headers = this.getHttpMetadata().headers().toSingleValueMap();
        Map<String, Object> requestMetadata = this.headersToMap(headers, () -> Optional.ofNullable((String)headers.get(TripleHeaderEnum.TRI_HEADER_CONVERT.getHeader())).map(CharSequence::toString).orElse(null));
        inv.setObjectAttachments(StreamUtils.toAttachments(requestMetadata));
        inv.put("tri.remote.address", this.httpChannel.remoteAddress());
        this.headerFilters.forEach(f -> f.invoke(invoker, inv));
        return inv;
    }

    protected static ServiceDescriptor getStubServiceDescriptor(URL url, String serviceName) {
        ServiceDescriptor serviceDescriptor = url.getServiceModel() != null ? url.getServiceModel().getServiceModel() : StubSuppliers.getServiceDescriptor(serviceName);
        return serviceDescriptor;
    }

    protected static ServiceDescriptor getReflectionServiceDescriptor(URL url) {
        ProviderModel providerModel = (ProviderModel)url.getServiceModel();
        if (providerModel == null || providerModel.getServiceModel() == null) {
            return null;
        }
        return providerModel.getServiceModel();
    }

    protected static boolean isEcho(String methodName) {
        return "$echo".equals(methodName);
    }

    protected static boolean isGeneric(String methodName) {
        return "$invoke".equals(methodName) || "$invokeAsync".equals(methodName);
    }

    protected static MethodDescriptor findReflectionMethodDescriptor(ServiceDescriptor serviceDescriptor, String methodName) {
        MethodDescriptor methodDescriptor = null;
        if (AbstractServerTransportListener.isGeneric(methodName)) {
            methodDescriptor = ServiceDescriptorInternalCache.genericService().getMethods(methodName).get(0);
        } else {
            if (AbstractServerTransportListener.isEcho(methodName)) {
                return ServiceDescriptorInternalCache.echoService().getMethods(methodName).get(0);
            }
            List<MethodDescriptor> methodDescriptors = serviceDescriptor.getMethods(methodName);
            if (CollectionUtils.isEmpty(methodDescriptors)) {
                String lowerMethod = Character.toLowerCase(methodName.charAt(0)) + methodName.substring(1);
                methodDescriptors = serviceDescriptor.getMethods(lowerMethod);
            }
            if (CollectionUtils.isEmpty(methodDescriptors)) {
                return null;
            }
            if (methodDescriptors.size() == 1) {
                methodDescriptor = methodDescriptors.get(0);
            }
            if (methodDescriptors.size() == 2) {
                if (methodDescriptors.get(1).getRpcType() == MethodDescriptor.RpcType.SERVER_STREAM) {
                    methodDescriptor = methodDescriptors.get(0);
                } else if (methodDescriptors.get(0).getRpcType() == MethodDescriptor.RpcType.SERVER_STREAM) {
                    methodDescriptor = methodDescriptors.get(1);
                }
            }
        }
        return methodDescriptor;
    }

    protected FrameworkModel getFrameworkModel() {
        return this.frameworkModel;
    }

    protected HEADER getHttpMetadata() {
        return this.httpMetadata;
    }

    protected Invoker<?> getInvoker() {
        return this.invoker;
    }

    protected ServiceDescriptor getServiceDescriptor() {
        return this.serviceDescriptor;
    }

    protected MethodDescriptor getMethodDescriptor() {
        return this.methodDescriptor;
    }

    public void setServiceDescriptor(ServiceDescriptor serviceDescriptor) {
        this.serviceDescriptor = serviceDescriptor;
    }

    public void setMethodDescriptor(MethodDescriptor methodDescriptor) {
        this.methodDescriptor = methodDescriptor;
    }

    public void setMethodMetadata(MethodMetadata methodMetadata) {
        this.methodMetadata = methodMetadata;
    }

    protected RpcInvocation getRpcInvocation() {
        return this.rpcInvocation;
    }

    public void setRpcInvocation(RpcInvocation rpcInvocation) {
        this.rpcInvocation = rpcInvocation;
    }

    protected MethodMetadata getMethodMetadata() {
        return this.methodMetadata;
    }

    protected HttpMessageCodec getHttpMessageCodec() {
        return this.httpMessageCodec;
    }

    protected void setHttpMessageListener(HttpMessageListener httpMessageListener) {
        this.httpMessageListener = httpMessageListener;
    }

    protected HttpMessageListener getHttpMessageListener() {
        return this.httpMessageListener;
    }

    protected PathResolver getPathResolver() {
        return this.pathResolver;
    }

    protected final URL getUrl() {
        return this.url;
    }

    public boolean isHasStub() {
        return this.hasStub;
    }

    protected Map<String, Object> headersToMap(Map<String, String> headers, Supplier<Object> convertUpperHeaderSupplier) {
        if (headers == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> attachments = new HashMap<String, Object>(headers.size());
        for (Map.Entry<String, String> header : headers.entrySet()) {
            String key = header.getKey();
            if (key.endsWith("-bin") && key.length() > "-bin".length()) {
                try {
                    String realKey = key.substring(0, key.length() - "-bin".length());
                    byte[] value = StreamUtils.decodeASCIIByte(header.getValue());
                    attachments.put(realKey, value);
                }
                catch (Exception e) {
                    LOGGER.error("4-9", "", "", "Failed to parse response attachment key=" + key, e);
                }
                continue;
            }
            attachments.put(key, header.getValue());
        }
        Object obj = convertUpperHeaderSupplier.get();
        if (obj == null) {
            return attachments;
        }
        if (obj instanceof String) {
            String json = TriRpcStatus.decodeMessage((String)obj);
            Map map = (Map)JsonUtils.toJavaObject(json, Map.class);
            for (Map.Entry entry : map.entrySet()) {
                Object val = attachments.remove(entry.getKey());
                if (val == null) continue;
                attachments.put((String)entry.getValue(), val);
            }
        } else {
            LOGGER.error("99-0", "wrong internal invocation", "", "Triple convertNoLowerCaseHeader error, obj is not String");
        }
        return attachments;
    }
}

