/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2FlowController;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2MultiplexHandler;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.flush.FlushConsolidationHandler;
import io.netty.handler.logging.LogLevel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.Configuration;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.remoting.api.AbstractWireProtocol;
import org.apache.dubbo.remoting.api.pu.ChannelHandlerPretender;
import org.apache.dubbo.remoting.api.pu.ChannelOperator;
import org.apache.dubbo.remoting.api.ssl.ContextOperator;
import org.apache.dubbo.remoting.http12.netty4.HttpWriteQueueHandler;
import org.apache.dubbo.remoting.http12.netty4.h1.NettyHttp1Codec;
import org.apache.dubbo.remoting.http12.netty4.h1.NettyHttp1ConnectionHandler;
import org.apache.dubbo.remoting.http12.netty4.h2.NettyHttp2FrameCodec;
import org.apache.dubbo.remoting.http12.netty4.h2.NettyHttp2ProtocolSelectorHandler;
import org.apache.dubbo.rpc.HeaderFilter;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.ScopeModelAware;
import org.apache.dubbo.rpc.protocol.tri.TriHttp2RemoteFlowController;
import org.apache.dubbo.rpc.protocol.tri.TripleHttp2FrameCodecBuilder;
import org.apache.dubbo.rpc.protocol.tri.h12.TripleProtocolDetector;
import org.apache.dubbo.rpc.protocol.tri.h12.http1.DefaultHttp11ServerTransportListenerFactory;
import org.apache.dubbo.rpc.protocol.tri.h12.http2.GenericHttp2ServerTransportListenerFactory;
import org.apache.dubbo.rpc.protocol.tri.transport.TripleClientHandler;
import org.apache.dubbo.rpc.protocol.tri.transport.TripleServerConnectionHandler;
import org.apache.dubbo.rpc.protocol.tri.transport.TripleTailHandler;

@Activate
public class TripleHttp2Protocol
extends AbstractWireProtocol
implements ScopeModelAware {
    private static final int MIB_1 = 0x100000;
    private static final int MIB_8 = 0x800000;
    private static final int KIB_32 = 32768;
    private static final int DEFAULT_MAX_HEADER_LIST_SIZE = 32768;
    private static final int DEFAULT_SETTING_HEADER_LIST_SIZE = 4096;
    private static final int DEFAULT_MAX_FRAME_SIZE = 0x800000;
    private static final int DEFAULT_WINDOW_INIT_SIZE = 0x800000;
    public static final Http2FrameLogger CLIENT_LOGGER = new Http2FrameLogger(LogLevel.DEBUG, "H2_CLIENT");
    public static final Http2FrameLogger SERVER_LOGGER = new Http2FrameLogger(LogLevel.DEBUG, "H2_SERVER");
    private ExtensionLoader<HeaderFilter> filtersLoader;
    private FrameworkModel frameworkModel;

    public TripleHttp2Protocol() {
        super(new TripleProtocolDetector());
    }

    @Override
    public void setFrameworkModel(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
        this.filtersLoader = frameworkModel.getExtensionLoader(HeaderFilter.class);
    }

    @Override
    public void close() {
        super.close();
    }

    @Override
    public void configClientPipeline(URL url, ChannelOperator operator, ContextOperator contextOperator) {
        Configuration config = ConfigurationUtils.getGlobalConfiguration(url.getOrDefaultApplicationModel());
        Http2FrameCodec codec = Http2FrameCodecBuilder.forClient().gracefulShutdownTimeoutMillis(10000L).initialSettings(new Http2Settings().headerTableSize((long)config.getInt("dubbo.rpc.tri.header-table-size", 4096)).pushEnabled(config.getBoolean("dubbo.rpc.tri.enable-push", false)).maxConcurrentStreams((long)config.getInt("dubbo.rpc.tri.max-concurrent-streams", Integer.MAX_VALUE)).initialWindowSize(config.getInt("dubbo.rpc.tri.initial-window-size", 0x800000)).maxFrameSize(config.getInt("dubbo.rpc.tri.max-frame-size", 0x800000)).maxHeaderListSize((long)config.getInt("dubbo.rpc.tri.max-header-list-size", 32768))).frameLogger(CLIENT_LOGGER).build();
        Http2MultiplexHandler handler = new Http2MultiplexHandler((ChannelHandler)new TripleClientHandler(this.frameworkModel));
        ArrayList<org.apache.dubbo.remoting.ChannelHandler> handlers = new ArrayList<org.apache.dubbo.remoting.ChannelHandler>();
        handlers.add(new ChannelHandlerPretender(codec));
        handlers.add(new ChannelHandlerPretender(handler));
        handlers.add(new ChannelHandlerPretender((Object)new TripleTailHandler()));
        operator.configChannelHandler(handlers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configServerProtocolHandler(URL url, ChannelOperator operator) {
        String httpVersion = operator.detectResult().getAttribute("HTTP_VERSION");
        ArrayList<org.apache.dubbo.remoting.ChannelHandler> channelHandlerPretenders = new ArrayList<org.apache.dubbo.remoting.ChannelHandler>();
        try {
            if (TripleProtocolDetector.HttpVersion.HTTP1.getVersion().equals(httpVersion)) {
                this.configurerHttp1Handlers(url, channelHandlerPretenders);
                return;
            }
            if (TripleProtocolDetector.HttpVersion.HTTP2.getVersion().equals(httpVersion)) {
                this.configurerHttp2Handlers(url, channelHandlerPretenders);
            }
        }
        finally {
            operator.configChannelHandler(channelHandlerPretenders);
        }
    }

    private void configurerHttp1Handlers(URL url, List<org.apache.dubbo.remoting.ChannelHandler> handlers) {
        handlers.add(new ChannelHandlerPretender(new HttpServerCodec()));
        handlers.add(new ChannelHandlerPretender(new HttpObjectAggregator(Integer.MAX_VALUE)));
        handlers.add(new ChannelHandlerPretender((Object)new NettyHttp1Codec()));
        handlers.add(new ChannelHandlerPretender((Object)new NettyHttp1ConnectionHandler(url, this.frameworkModel, DefaultHttp11ServerTransportListenerFactory.INSTANCE)));
    }

    private void configurerHttp2Handlers(final URL url, List<org.apache.dubbo.remoting.ChannelHandler> handlers) {
        Configuration config = ConfigurationUtils.getGlobalConfiguration(url.getOrDefaultApplicationModel());
        if (this.filtersLoader != null) {
            List<HeaderFilter> headFilters = this.filtersLoader.getActivateExtension(url, "header.filter");
        } else {
            List headFilters = Collections.emptyList();
        }
        Http2FrameCodec codec = TripleHttp2FrameCodecBuilder.forServer().customizeConnection(connection -> connection.remote().flowController((Http2FlowController)new TriHttp2RemoteFlowController((Http2Connection)connection, url.getOrDefaultApplicationModel()))).gracefulShutdownTimeoutMillis(10000L).initialSettings(new Http2Settings().headerTableSize((long)config.getInt("dubbo.rpc.tri.header-table-size", 4096)).maxConcurrentStreams((long)config.getInt("dubbo.rpc.tri.max-concurrent-streams", Integer.MAX_VALUE)).initialWindowSize(config.getInt("dubbo.rpc.tri.initial-window-size", 0x800000)).maxFrameSize(config.getInt("dubbo.rpc.tri.max-frame-size", 0x800000)).maxHeaderListSize((long)config.getInt("dubbo.rpc.tri.max-header-list-size", 32768))).frameLogger(SERVER_LOGGER).build();
        Http2MultiplexHandler handler = new Http2MultiplexHandler((ChannelHandler)new ChannelInitializer<Http2StreamChannel>(){

            protected void initChannel(Http2StreamChannel ch) {
                ChannelPipeline p = ch.pipeline();
                p.addLast(new ChannelHandler[]{new NettyHttp2FrameCodec()});
                p.addLast(new ChannelHandler[]{new NettyHttp2ProtocolSelectorHandler(url, TripleHttp2Protocol.this.frameworkModel, GenericHttp2ServerTransportListenerFactory.INSTANCE)});
            }
        });
        handlers.add(new ChannelHandlerPretender((Object)new HttpWriteQueueHandler()));
        handlers.add(new ChannelHandlerPretender(codec));
        handlers.add(new ChannelHandlerPretender(new FlushConsolidationHandler(64, true)));
        handlers.add(new ChannelHandlerPretender((Object)new TripleServerConnectionHandler()));
        handlers.add(new ChannelHandlerPretender(handler));
    }
}

