/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest.util;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.http.RequestTemplate;
import org.apache.dubbo.remoting.http.RestResult;
import org.apache.dubbo.rpc.AppResponse;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.protocol.rest.RestHeaderEnum;
import org.apache.dubbo.rpc.protocol.rest.netty.NettyHttpResponse;
import org.apache.dubbo.rpc.protocol.rest.request.RequestFacade;

public class HttpHeaderUtil {
    public static Map<String, List<String>> createAttachments(Map<String, Object> attachmentMap) {
        HashMap<String, List<String>> attachments = new HashMap<String, List<String>>();
        int size = 0;
        for (Map.Entry<String, Object> entry : attachmentMap.entrySet()) {
            ArrayList<String> strings;
            String key = entry.getKey();
            String value = String.valueOf(entry.getValue());
            if (value != null) {
                size += value.getBytes(StandardCharsets.UTF_8).length;
            }
            if ((strings = (ArrayList<String>)attachments.get(key)) == null) {
                strings = new ArrayList<String>();
                attachments.put(key, strings);
            }
            strings.add(value);
        }
        return attachments;
    }

    public static void addRequestAttachments(RequestTemplate requestTemplate, Map<String, Object> attachmentMap) {
        Map<String, List<String>> attachments = HttpHeaderUtil.createAttachments(attachmentMap);
        attachments.entrySet().forEach(attachment -> requestTemplate.addHeaders(HttpHeaderUtil.appendPrefixToAttachRealHeader((String)attachment.getKey()), (Collection)attachment.getValue()));
    }

    public static void addResponseAttachments(NettyHttpResponse nettyHttpResponse) {
        Map<String, List<String>> attachments = HttpHeaderUtil.createAttachments(RpcContext.getServerContext().getObjectAttachments());
        attachments.entrySet().stream().forEach(attachment -> nettyHttpResponse.getOutputHeaders().put(HttpHeaderUtil.appendPrefixToAttachRealHeader((String)attachment.getKey()), (List)attachment.getValue()));
    }

    public static void parseRequestHeader(RpcInvocation rpcInvocation, RequestFacade requestFacade) {
        Enumeration<String> headerNames = requestFacade.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String header = headerNames.nextElement();
            if (!HttpHeaderUtil.isRestAttachHeader(header)) {
                rpcInvocation.put(header, requestFacade.getHeader(header));
                continue;
            }
            rpcInvocation.setAttachment(HttpHeaderUtil.subRestAttachRealHeaderPrefix(header.trim()), requestFacade.getHeader(header));
        }
    }

    public static boolean isRestAttachHeader(String header) {
        return !StringUtils.isEmpty(header) && header.startsWith(RestHeaderEnum.REST_HEADER_PREFIX.getHeader());
    }

    public static String subRestAttachRealHeaderPrefix(String header) {
        return header.substring(RestHeaderEnum.REST_HEADER_PREFIX.getHeader().length());
    }

    public static String appendPrefixToAttachRealHeader(String header) {
        return RestHeaderEnum.REST_HEADER_PREFIX.getHeader() + header;
    }

    public static void parseRequestAttribute(RpcInvocation rpcInvocation, RequestFacade request) {
        int localPort = request.getLocalPort();
        String localAddr = request.getLocalAddr();
        int remotePort = request.getRemotePort();
        String remoteAddr = request.getRemoteAddr();
        rpcInvocation.put("REMOTE_ADDR", remoteAddr);
        rpcInvocation.put("LOCAL_ADDR", localAddr);
        rpcInvocation.put("REMOTE_PORT", remotePort);
        rpcInvocation.put("LOCAL_PORT", localPort);
    }

    public static void parseRequest(RpcInvocation rpcInvocation, RequestFacade request) {
        HttpHeaderUtil.parseRequestHeader(rpcInvocation, request);
        HttpHeaderUtil.parseRequestAttribute(rpcInvocation, request);
    }

    public static void parseResponseHeader(AppResponse appResponse, RestResult restResult) {
        Map<String, List<String>> headers = restResult.headers();
        if (headers == null || headers.isEmpty()) {
            return;
        }
        headers.entrySet().stream().forEach(entry -> {
            String header = (String)entry.getKey();
            if (HttpHeaderUtil.isRestAttachHeader(header)) {
                appResponse.setAttachment(HttpHeaderUtil.subRestAttachRealHeaderPrefix(header), entry.getValue());
            } else {
                appResponse.setAttribute(header, entry.getValue());
            }
        });
    }
}

