/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest.pu;

import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.api.AbstractWireProtocol;
import org.apache.dubbo.remoting.api.pu.ChannelHandlerPretender;
import org.apache.dubbo.remoting.api.pu.ChannelOperator;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.ScopeModelAware;
import org.apache.dubbo.rpc.protocol.rest.deploy.ServiceDeployer;
import org.apache.dubbo.rpc.protocol.rest.netty.RestHttpRequestDecoder;
import org.apache.dubbo.rpc.protocol.rest.pu.RestHttp1Detector;

@Activate(order=0x7FFFFFFF)
public class RestHttp1WireProtocol
extends AbstractWireProtocol
implements ScopeModelAware {
    private static final ServiceDeployer emptyServiceDeployer = new ServiceDeployer();

    public RestHttp1WireProtocol(FrameworkModel frameworkModel) {
        super(new RestHttp1Detector(frameworkModel));
    }

    @Override
    public void configServerProtocolHandler(URL url, ChannelOperator operator) {
        ServiceDeployer serviceDeployer = (ServiceDeployer)url.getAttribute("restServiceDeployerAttributeKey");
        if (serviceDeployer == null) {
            serviceDeployer = emptyServiceDeployer;
        }
        List<Object> channelHandlers = Arrays.asList(new Object[]{new HttpRequestDecoder(url.getParameter("max.initial.line.length", 4096), url.getParameter("max.header.size", 8192), url.getParameter("max.chunk.size", 8192)), new HttpObjectAggregator(url.getParameter("max.request.size", 0xA00000)), new HttpResponseEncoder(), new RestHttpRequestDecoder(url, serviceDeployer)});
        ArrayList<ChannelHandler> handlers = new ArrayList<ChannelHandler>();
        handlers.add(new ChannelHandlerPretender(channelHandlers));
        operator.configChannelHandler(handlers);
    }
}

