/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest.pu;

import org.apache.dubbo.remoting.api.AbstractHttpProtocolDetector;
import org.apache.dubbo.remoting.api.ProtocolDetector;
import org.apache.dubbo.remoting.buffer.ChannelBuffer;
import org.apache.dubbo.rpc.model.FrameworkModel;

public class RestHttp1Detector
extends AbstractHttpProtocolDetector {
    private static final char[][] HTTP_METHODS_PREFIX = RestHttp1Detector.getHttpMethodsPrefix();
    private FrameworkModel frameworkModel;

    public RestHttp1Detector(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
    }

    @Override
    public ProtocolDetector.Result detect(ChannelBuffer in) {
        int i = in.readableBytes();
        if (i < SIMPLE_HTTP.length()) {
            return ProtocolDetector.Result.unrecognized();
        }
        if (this.prefixMatch(HTTP_METHODS_PREFIX, in, 3)) {
            return ProtocolDetector.Result.recognized();
        }
        return ProtocolDetector.Result.unrecognized();
    }
}

