/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest.annotation.param.parse.provider;

import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.metadata.rest.ArgInfo;
import org.apache.dubbo.metadata.rest.ParamType;
import org.apache.dubbo.rpc.protocol.rest.annotation.param.parse.provider.ProviderParamParser;
import org.apache.dubbo.rpc.protocol.rest.annotation.param.parse.provider.ProviderParseContext;
import org.apache.dubbo.rpc.protocol.rest.request.RequestFacade;

@Activate(value={"param"})
public class ParamProviderParamParser
extends ProviderParamParser {
    @Override
    protected void doParse(ProviderParseContext parseContext, ArgInfo argInfo) {
        RequestFacade request = parseContext.getRequestFacade();
        if (Map.class.isAssignableFrom(argInfo.getParamType())) {
            LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
            Enumeration<String> parameterNames = request.getParameterNames();
            while (parameterNames.hasMoreElements()) {
                String name = parameterNames.nextElement();
                paramMap.put(name, request.getParameter(name));
            }
            parseContext.setValueByIndex(argInfo.getIndex(), paramMap);
            return;
        }
        String param = request.getParameter(argInfo.getAnnotationNameAttribute());
        Object paramValue = this.paramTypeConvert(argInfo.getParamType(), param);
        parseContext.setValueByIndex(argInfo.getIndex(), paramValue);
    }

    @Override
    public ParamType getParamType() {
        return ParamType.PARAM;
    }
}

