/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.ConcurrentHashMapUtils;
import org.apache.dubbo.common.utils.JsonCompatibilityUtil;
import org.apache.dubbo.metadata.rest.ServiceRestMetadata;
import org.apache.dubbo.remoting.api.pu.DefaultPuHandler;
import org.apache.dubbo.remoting.exchange.PortUnificationExchanger;
import org.apache.dubbo.remoting.http.RestClient;
import org.apache.dubbo.remoting.http.factory.RestClientFactory;
import org.apache.dubbo.rpc.Exporter;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.ProtocolServer;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.AbstractExporter;
import org.apache.dubbo.rpc.protocol.AbstractProtocol;
import org.apache.dubbo.rpc.protocol.rest.ReferenceCountedClient;
import org.apache.dubbo.rpc.protocol.rest.RestInvoker;
import org.apache.dubbo.rpc.protocol.rest.annotation.consumer.HttpConnectionPreBuildIntercept;
import org.apache.dubbo.rpc.protocol.rest.annotation.metadata.MetadataResolver;
import org.apache.dubbo.rpc.protocol.rest.deploy.ServiceDeployer;
import org.apache.dubbo.rpc.protocol.rest.deploy.ServiceDeployerManager;

public class RestProtocol
extends AbstractProtocol {
    private static final int DEFAULT_PORT = 80;
    private final ConcurrentMap<String, ReferenceCountedClient<? extends RestClient>> clients = new ConcurrentHashMap<String, ReferenceCountedClient<? extends RestClient>>();
    private final RestClientFactory clientFactory;
    private final Set<HttpConnectionPreBuildIntercept> httpConnectionPreBuildIntercepts;

    public RestProtocol(FrameworkModel frameworkModel) {
        this.clientFactory = frameworkModel.getExtensionLoader(RestClientFactory.class).getAdaptiveExtension();
        this.httpConnectionPreBuildIntercepts = new LinkedHashSet<HttpConnectionPreBuildIntercept>(frameworkModel.getExtensionLoader(HttpConnectionPreBuildIntercept.class).getActivateExtensions());
    }

    @Override
    public int getDefaultPort() {
        return 80;
    }

    @Override
    public <T> Exporter<T> export(Invoker<T> invoker) throws RpcException {
        URL url = invoker.getUrl();
        final String uri = RestProtocol.serviceKey(url);
        Exporter exporter = (Exporter)this.exporterMap.get(uri);
        if (exporter != null && Objects.equals(exporter.getInvoker().getUrl(), invoker.getUrl())) {
            return exporter;
        }
        final ServiceRestMetadata serviceRestMetadata = MetadataResolver.resolveProviderServiceMetadata(url.getServiceModel().getProxyObject().getClass(), url, this.getContextPath(url));
        String jsonCheckLevel = url.getUrlParam().getParameter("jsonCheckLevel");
        this.checkJsonCompatibility(invoker.getInterface(), jsonCheckLevel);
        URL newURL = ServiceDeployerManager.deploy(url, serviceRestMetadata, invoker);
        PortUnificationExchanger.bind(newURL, new DefaultPuHandler());
        final ServiceDeployer serviceDeployer = (ServiceDeployer)newURL.getAttribute("restServiceDeployerAttributeKey");
        final URL finalUrl = newURL;
        exporter = new AbstractExporter<T>(invoker){

            @Override
            public void afterUnExport() {
                RestProtocol.this.destroyInternal(finalUrl);
                RestProtocol.this.exporterMap.remove(uri);
                serviceDeployer.undeploy(serviceRestMetadata);
            }
        };
        this.exporterMap.put(uri, exporter);
        return exporter;
    }

    private void checkJsonCompatibility(Class<?> clazz, String jsonCheckLevel) throws RpcException {
        if (jsonCheckLevel == null || "warn".equals(jsonCheckLevel)) {
            boolean compatibility = JsonCompatibilityUtil.checkClassCompatibility(clazz);
            if (!compatibility) {
                List<String> unsupportedMethods = JsonCompatibilityUtil.getUnsupportedMethods(clazz);
                assert (unsupportedMethods != null);
                this.logger.warn("", "", "", String.format("Interface %s does not support json serialization, the specific methods are %s.", clazz.getName(), unsupportedMethods));
            } else {
                this.logger.debug("Check json compatibility complete, all methods of {} can be serialized using json.", clazz.getName());
            }
        } else if ("strict".equals(jsonCheckLevel)) {
            boolean compatibility = JsonCompatibilityUtil.checkClassCompatibility(clazz);
            if (!compatibility) {
                List<String> unsupportedMethods = JsonCompatibilityUtil.getUnsupportedMethods(clazz);
                assert (unsupportedMethods != null);
                throw new IllegalStateException(String.format("Interface %s does not support json serialization, the specific methods are %s.", clazz.getName(), unsupportedMethods));
            }
            this.logger.debug("Check json compatibility complete, all methods of {} can be serialized using json.", clazz.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T> Invoker<T> protocolBindingRefer(Class<T> type, URL url) throws RpcException {
        ReferenceCountedClient refClient = (ReferenceCountedClient)this.clients.get(url.getAddress());
        if (refClient == null || refClient.isDestroyed()) {
            ConcurrentMap<String, ReferenceCountedClient<? extends RestClient>> concurrentMap = this.clients;
            synchronized (concurrentMap) {
                refClient = (ReferenceCountedClient)this.clients.get(url.getAddress());
                if (refClient == null || refClient.isDestroyed()) {
                    refClient = ConcurrentHashMapUtils.computeIfAbsent(this.clients, url.getAddress(), _key -> this.createReferenceCountedClient(url));
                }
            }
        }
        refClient.retain();
        String contextPathFromUrl = this.getContextPath(url);
        ServiceRestMetadata serviceRestMetadata = MetadataResolver.resolveConsumerServiceMetadata(type, url, contextPathFromUrl);
        RestInvoker invoker = new RestInvoker(type, url, refClient, this.httpConnectionPreBuildIntercepts, serviceRestMetadata);
        this.invokers.add(invoker);
        return invoker;
    }

    private ReferenceCountedClient<? extends RestClient> createReferenceCountedClient(URL url) throws RpcException {
        RestClient restClient = this.clientFactory.createRestClient(url);
        return new ReferenceCountedClient<RestClient>(restClient, this.clients, this.clientFactory, url);
    }

    @Override
    public void destroy() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Destroying protocol [" + this.getClass().getSimpleName() + "] ...");
        }
        PortUnificationExchanger.close();
        ServiceDeployerManager.close();
        super.destroy();
        for (Map.Entry entry : this.serverMap.entrySet()) {
            try {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Closing the rest server at " + (String)entry.getKey());
                }
                ((ProtocolServer)entry.getValue()).close();
            }
            catch (Throwable t) {
                this.logger.warn("4-8", "", "", "Error closing rest server", t);
            }
        }
        this.serverMap.clear();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Closing rest clients");
        }
        for (ReferenceCountedClient client : this.clients.values()) {
            try {
                client.destroy();
            }
            catch (Throwable t) {
                this.logger.warn("4-7", "", "", "Error closing rest client", t);
            }
        }
        this.clients.clear();
    }

    private String getContextPath(URL url) {
        String contextPath = url.getPath();
        if (contextPath != null) {
            if (contextPath.equalsIgnoreCase(url.getParameter("interface"))) {
                return "";
            }
            if (contextPath.endsWith(url.getParameter("interface"))) {
                contextPath = contextPath.substring(0, contextPath.lastIndexOf(url.getParameter("interface")));
            }
            return contextPath.endsWith("/") ? contextPath.substring(0, contextPath.length() - 1) : contextPath;
        }
        return "";
    }

    private void destroyInternal(URL url) {
        try {
            ReferenceCountedClient referenceCountedClient = (ReferenceCountedClient)this.clients.get(url.getAddress());
            if (referenceCountedClient != null && referenceCountedClient.release()) {
                this.clients.remove(url.getAddress());
            }
        }
        catch (Exception e) {
            this.logger.warn("4-7", "", "", "Failed to close unused resources in rest protocol. interfaceName [" + url.getServiceInterface() + "]", e);
        }
    }
}

