/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12.netty4.h1;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.remoting.http12.HttpHeaderNames;
import org.apache.dubbo.remoting.http12.HttpHeaders;
import org.apache.dubbo.remoting.http12.HttpMetadata;
import org.apache.dubbo.remoting.http12.HttpOutputMessage;
import org.apache.dubbo.remoting.http12.h1.DefaultHttp1Request;
import org.apache.dubbo.remoting.http12.h1.Http1InputMessage;
import org.apache.dubbo.remoting.http12.h1.Http1RequestMetadata;

public class NettyHttp1Codec
extends ChannelDuplexHandler {
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof FullHttpRequest) {
            FullHttpRequest fullHttpRequest = (FullHttpRequest)msg;
            io.netty.handler.codec.http.HttpHeaders headers = fullHttpRequest.headers();
            Http1RequestMetadata http1RequestMetadata = new Http1RequestMetadata();
            http1RequestMetadata.setPath(fullHttpRequest.uri());
            http1RequestMetadata.setMethod(fullHttpRequest.method().name());
            HttpHeaders httpHeaders = new HttpHeaders();
            for (Map.Entry header : headers) {
                String key = (String)header.getKey();
                httpHeaders.set(key, (String)header.getValue());
            }
            http1RequestMetadata.setHeaders(httpHeaders);
            DefaultHttp1Request http1Request = new DefaultHttp1Request(http1RequestMetadata, new Http1InputMessage((InputStream)new ByteBufInputStream(fullHttpRequest.content(), true)));
            super.channelRead(ctx, (Object)http1Request);
            return;
        }
        super.channelRead(ctx, msg);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof HttpMetadata) {
            this.doWriteHeader(ctx, (HttpMetadata)msg, promise);
            return;
        }
        if (msg instanceof HttpOutputMessage) {
            this.doWriteMessage(ctx, (HttpOutputMessage)msg, promise);
            return;
        }
        super.write(ctx, msg, promise);
    }

    private void doWriteHeader(ChannelHandlerContext ctx, HttpMetadata msg, ChannelPromise promise) {
        Object statusHeaders = msg.headers().remove(HttpHeaderNames.STATUS.getName());
        HttpResponseStatus status = HttpResponseStatus.OK;
        if (statusHeaders != null && !statusHeaders.isEmpty()) {
            status = HttpResponseStatus.valueOf((int)Integer.parseInt((String)statusHeaders.get(0)));
        }
        DefaultHttpResponse defaultHttpResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status);
        io.netty.handler.codec.http.HttpHeaders headers = defaultHttpResponse.headers();
        for (Map.Entry<String, List<String>> entry : msg.headers().entrySet()) {
            headers.set(entry.getKey(), (Iterable)entry.getValue());
        }
        ctx.writeAndFlush((Object)defaultHttpResponse, promise);
    }

    private void doWriteMessage(ChannelHandlerContext ctx, HttpOutputMessage msg, ChannelPromise promise) {
        if (HttpOutputMessage.EMPTY_MESSAGE == msg) {
            ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT, promise);
            return;
        }
        OutputStream body = msg.getBody();
        if (body instanceof ByteBufOutputStream) {
            ByteBuf buffer = ((ByteBufOutputStream)body).buffer();
            ctx.writeAndFlush((Object)buffer, promise);
            return;
        }
        throw new IllegalArgumentException("HttpOutputMessage body must be 'io.netty.buffer.ByteBufOutputStream'");
    }
}

