/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12.message;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.remoting.http12.message.HttpMessageCodec;
import org.apache.dubbo.remoting.http12.message.HttpMessageCodecFactory;
import org.apache.dubbo.remoting.http12.message.JsonPbCodec;
import org.apache.dubbo.remoting.http12.message.MediaType;
import org.apache.dubbo.rpc.model.FrameworkModel;

@Activate(order=-100)
public class JsonPbCodecFactory
implements HttpMessageCodecFactory {
    @Override
    public HttpMessageCodec createCodec(URL url, FrameworkModel frameworkModel) {
        HttpMessageCodec codec = frameworkModel.getExtensionLoader(HttpMessageCodecFactory.class).getExtension("json").createCodec(url, frameworkModel);
        JsonPbCodec jsonPbCodec = new JsonPbCodec();
        jsonPbCodec.setJsonCodec(codec);
        return jsonPbCodec;
    }

    @Override
    public MediaType contentType() {
        return MediaType.APPLICATION_JSON_VALUE;
    }

    @Override
    public boolean support(String contentType) {
        return HttpMessageCodecFactory.super.support(contentType) && ClassUtils.isPresent("com.google.protobuf.Message", this.getClass().getClassLoader());
    }
}

