/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12.message;

import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.common.utils.MethodUtils;
import org.apache.dubbo.remoting.http12.exception.DecodeException;
import org.apache.dubbo.remoting.http12.exception.EncodeException;
import org.apache.dubbo.remoting.http12.message.HttpMessageCodec;
import org.apache.dubbo.remoting.http12.message.MediaType;

@Activate
public class JsonPbCodec
implements HttpMessageCodec {
    private HttpMessageCodec jsonCodec;

    public void setJsonCodec(HttpMessageCodec jsonCodec) {
        this.jsonCodec = jsonCodec;
    }

    @Override
    public MediaType contentType() {
        return this.jsonCodec.contentType();
    }

    @Override
    public boolean support(String contentType) {
        return HttpMessageCodec.super.support(contentType) && ClassUtils.isPresent("com.google.protobuf.Message", this.getClass().getClassLoader());
    }

    @Override
    public void encode(OutputStream outputStream, Object unSerializedBody) throws EncodeException {
        try {
            if (unSerializedBody instanceof Message) {
                String jsonString = JsonFormat.printer().print((MessageOrBuilder)((Message)unSerializedBody));
                outputStream.write(jsonString.getBytes(StandardCharsets.UTF_8));
                return;
            }
        }
        catch (IOException e) {
            throw new EncodeException(e);
        }
        this.jsonCodec.encode(outputStream, unSerializedBody);
    }

    @Override
    public void encode(OutputStream outputStream, Object[] data) throws EncodeException {
        this.jsonCodec.encode(outputStream, data);
    }

    @Override
    public Object decode(InputStream body, Class<?> targetType) throws DecodeException {
        try {
            if (JsonPbCodec.isProtobuf(targetType)) {
                int len;
                byte[] data = new byte[4096];
                StringBuilder builder = new StringBuilder(4096);
                while ((len = body.read(data)) != -1) {
                    builder.append(new String(data, 0, len));
                }
                Message.Builder newBuilder = (Message.Builder)MethodUtils.findMethod(targetType, "newBuilder").invoke(null, new Object[0]);
                JsonFormat.parser().ignoringUnknownFields().merge(builder.toString(), newBuilder);
                return newBuilder.build();
            }
        }
        catch (Throwable e) {
            throw new DecodeException(e);
        }
        return this.jsonCodec.decode(body, targetType);
    }

    @Override
    public Object[] decode(InputStream dataInputStream, Class<?>[] targetTypes) throws DecodeException {
        try {
            if (JsonPbCodec.hasProtobuf(targetTypes)) {
                return new Object[]{this.decode(dataInputStream, targetTypes[0])};
            }
        }
        catch (Throwable e) {
            throw new DecodeException(e);
        }
        return this.jsonCodec.decode(dataInputStream, targetTypes);
    }

    private static boolean isProtobuf(Class<?> targetType) {
        if (targetType == null) {
            return false;
        }
        return Message.class.isAssignableFrom(targetType);
    }

    private static boolean hasProtobuf(Class<?>[] classes) {
        for (Class<?> clazz : classes) {
            if (!JsonPbCodec.isProtobuf(clazz)) continue;
            return true;
        }
        return false;
    }
}

