/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12.message;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.utils.JsonUtils;
import org.apache.dubbo.remoting.http12.exception.DecodeException;
import org.apache.dubbo.remoting.http12.exception.EncodeException;
import org.apache.dubbo.remoting.http12.message.HttpMessageCodec;
import org.apache.dubbo.remoting.http12.message.MediaType;

@Activate
public class JsonCodec
implements HttpMessageCodec {
    public static final HttpMessageCodec INSTANCE = new JsonCodec();

    @Override
    public MediaType contentType() {
        return MediaType.APPLICATION_JSON_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encode(OutputStream outputStream, Object unSerializedBody) throws EncodeException {
        try {
            try {
                String jsonString = JsonUtils.toJson(unSerializedBody);
                outputStream.write(jsonString.getBytes(StandardCharsets.UTF_8));
            }
            finally {
                outputStream.flush();
            }
        }
        catch (Throwable e) {
            throw new EncodeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encode(OutputStream outputStream, Object[] data) throws EncodeException {
        try {
            try {
                String jsonString = JsonUtils.toJson(data);
                outputStream.write(jsonString.getBytes(StandardCharsets.UTF_8));
            }
            finally {
                outputStream.flush();
            }
        }
        catch (Throwable e) {
            throw new EncodeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object decode(InputStream body, Class<?> targetType) throws DecodeException {
        Object t;
        try {
            int len;
            byte[] data = new byte[4096];
            StringBuilder builder = new StringBuilder(4096);
            while ((len = body.read(data)) != -1) {
                builder.append(new String(data, 0, len));
            }
            t = JsonUtils.toJavaObject(builder.toString(), targetType);
        }
        catch (Throwable throwable) {
            try {
                body.close();
                throw throwable;
            }
            catch (Throwable e) {
                throw new DecodeException(e);
            }
        }
        body.close();
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] decode(InputStream dataInputStream, Class<?>[] targetTypes) throws DecodeException {
        Object[] objectArray;
        ArrayList<Object> result = new ArrayList<Object>();
        try {
            int len;
            byte[] data = new byte[4096];
            StringBuilder builder = new StringBuilder(4096);
            while ((len = dataInputStream.read(data)) != -1) {
                builder.append(new String(data, 0, len));
            }
            String jsonString = builder.toString();
            List<Object> jsonObjects = JsonUtils.toJavaList(jsonString, Object.class);
            for (int i = 0; i < targetTypes.length; ++i) {
                Object jsonObject = jsonObjects.get(i);
                Class<?> type = targetTypes[i];
                if (jsonObject instanceof JSONObject) {
                    Object o = ((JSONObject)jsonObject).toJavaObject(type, new JSONReader.Feature[0]);
                    result.add(o);
                    continue;
                }
                result.add(jsonObject);
            }
            objectArray = result.toArray();
        }
        catch (Throwable throwable) {
            try {
                dataInputStream.close();
                throw throwable;
            }
            catch (Throwable e) {
                throw new DecodeException(e);
            }
        }
        dataInputStream.close();
        return objectArray;
    }
}

