/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12;

import java.io.IOException;
import java.io.InputStream;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.dubbo.remoting.http12.exception.DecodeException;

public class CompositeInputStream
extends InputStream {
    private final Queue<InputStream> inputStreams = new ConcurrentLinkedQueue<InputStream>();
    private int totalAvailable = 0;
    private int readIndex = 0;

    public void addInputStream(InputStream inputStream) {
        this.inputStreams.offer(inputStream);
        try {
            this.totalAvailable += inputStream.available();
        }
        catch (IOException e) {
            throw new DecodeException(e);
        }
    }

    @Override
    public int read() throws IOException {
        InputStream inputStream;
        while ((inputStream = this.inputStreams.peek()) != null) {
            int available = inputStream.available();
            if (available == 0) {
                this.releaseHeadStream();
                continue;
            }
            int read = inputStream.read();
            if (read != -1) {
                ++this.readIndex;
                this.releaseIfNecessary(inputStream);
                return read;
            }
            this.releaseHeadStream();
        }
        return -1;
    }

    @Override
    public int available() {
        return this.totalAvailable - this.readIndex;
    }

    @Override
    public void close() throws IOException {
        InputStream inputStream;
        while ((inputStream = this.inputStreams.poll()) != null) {
            inputStream.close();
        }
    }

    private void releaseHeadStream() throws IOException {
        InputStream removeStream = this.inputStreams.remove();
        removeStream.close();
    }

    private void releaseIfNecessary(InputStream inputStream) throws IOException {
        int available = inputStream.available();
        if (available == 0) {
            inputStream.close();
            this.releaseHeadStream();
        }
    }
}

