/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.api;

import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.function.Predicate;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.qos.api.PermissionLevel;

public class QosConfiguration {
    private String welcome;
    private boolean acceptForeignIp;
    private String acceptForeignIpWhitelist;
    private Predicate<String> acceptForeignIpWhitelistPredicate;
    private PermissionLevel anonymousAccessPermissionLevel = PermissionLevel.PUBLIC;
    private String anonymousAllowCommands;

    private QosConfiguration() {
    }

    public QosConfiguration(Builder builder) {
        this.welcome = builder.getWelcome();
        this.acceptForeignIp = builder.isAcceptForeignIp();
        this.acceptForeignIpWhitelist = builder.getAcceptForeignIpWhitelist();
        this.anonymousAccessPermissionLevel = builder.getAnonymousAccessPermissionLevel();
        this.anonymousAllowCommands = builder.getAnonymousAllowCommands();
        this.buildPredicate();
    }

    private void buildPredicate() {
        this.acceptForeignIpWhitelistPredicate = StringUtils.isNotEmpty(this.acceptForeignIpWhitelist) ? Arrays.stream(this.acceptForeignIpWhitelist.split(",")).map(String::trim).filter(StringUtils::isNotEmpty).map(foreignIpPattern -> foreignIp -> {
            try {
                return NetUtils.matchIpExpression(foreignIpPattern, foreignIp, -1);
            }
            catch (UnknownHostException unknownHostException) {
                return false;
            }
        }).reduce(Predicate::or).orElse(s -> false) : foreignIp -> false;
    }

    public boolean isAllowAnonymousAccess() {
        return PermissionLevel.NONE != this.anonymousAccessPermissionLevel;
    }

    public String getWelcome() {
        return this.welcome;
    }

    public PermissionLevel getAnonymousAccessPermissionLevel() {
        return this.anonymousAccessPermissionLevel;
    }

    public String getAcceptForeignIpWhitelist() {
        return this.acceptForeignIpWhitelist;
    }

    public Predicate<String> getAcceptForeignIpWhitelistPredicate() {
        return this.acceptForeignIpWhitelistPredicate;
    }

    public boolean isAcceptForeignIp() {
        return this.acceptForeignIp;
    }

    public String getAnonymousAllowCommands() {
        return this.anonymousAllowCommands;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String welcome;
        private boolean acceptForeignIp;
        private String acceptForeignIpWhitelist;
        private PermissionLevel anonymousAccessPermissionLevel = PermissionLevel.PUBLIC;
        private String anonymousAllowCommands;

        private Builder() {
        }

        public Builder welcome(String welcome) {
            this.welcome = welcome;
            return this;
        }

        public Builder acceptForeignIp(boolean acceptForeignIp) {
            this.acceptForeignIp = acceptForeignIp;
            return this;
        }

        public Builder acceptForeignIpWhitelist(String acceptForeignIpWhitelist) {
            this.acceptForeignIpWhitelist = acceptForeignIpWhitelist;
            return this;
        }

        public Builder anonymousAccessPermissionLevel(String anonymousAccessPermissionLevel) {
            this.anonymousAccessPermissionLevel = PermissionLevel.from(anonymousAccessPermissionLevel);
            return this;
        }

        public Builder anonymousAllowCommands(String anonymousAllowCommands) {
            this.anonymousAllowCommands = anonymousAllowCommands;
            return this;
        }

        public QosConfiguration build() {
            return new QosConfiguration(this);
        }

        public String getWelcome() {
            return this.welcome;
        }

        public boolean isAcceptForeignIp() {
            return this.acceptForeignIp;
        }

        public String getAcceptForeignIpWhitelist() {
            return this.acceptForeignIpWhitelist;
        }

        public PermissionLevel getAnonymousAccessPermissionLevel() {
            return this.anonymousAccessPermissionLevel;
        }

        public String getAnonymousAllowCommands() {
            return this.anonymousAllowCommands;
        }
    }
}

