/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.report;

import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.instrument.binder.jvm.ClassLoaderMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.core.instrument.binder.system.UptimeMetrics;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.beans.factory.ScopeBeanFactory;
import org.apache.dubbo.common.lang.ShutdownHookCallbacks;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.metrics.MetricsGlobalRegistry;
import org.apache.dubbo.metrics.collector.AggregateMetricsCollector;
import org.apache.dubbo.metrics.collector.HistogramMetricsCollector;
import org.apache.dubbo.metrics.collector.MetricsCollector;
import org.apache.dubbo.metrics.model.sample.CounterMetricSample;
import org.apache.dubbo.metrics.model.sample.GaugeMetricSample;
import org.apache.dubbo.metrics.model.sample.MetricSample;
import org.apache.dubbo.metrics.report.MetricsReporter;
import org.apache.dubbo.rpc.model.ApplicationModel;

public abstract class AbstractMetricsReporter
implements MetricsReporter {
    private final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(AbstractMetricsReporter.class);
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    protected final URL url;
    protected final List<MetricsCollector> collectors = new ArrayList<MetricsCollector>();
    protected final List<MeterBinder> instanceHolder = new ArrayList<MeterBinder>();
    protected final CompositeMeterRegistry compositeRegistry;
    private final ApplicationModel applicationModel;
    private ScheduledExecutorService collectorSyncJobExecutor = null;
    private static final int DEFAULT_SCHEDULE_INITIAL_DELAY = 5;
    private static final int DEFAULT_SCHEDULE_PERIOD = 3;

    protected AbstractMetricsReporter(URL url, ApplicationModel applicationModel) {
        this.url = url;
        this.applicationModel = applicationModel;
        this.compositeRegistry = MetricsGlobalRegistry.getCompositeRegistry(applicationModel);
    }

    @Override
    public void init() {
        if (this.initialized.compareAndSet(false, true)) {
            this.addJvmMetrics();
            this.initCollectors();
            this.scheduleMetricsCollectorSyncJob();
            this.doInit();
            this.registerDubboShutdownHook();
        }
    }

    protected void addMeterRegistry(MeterRegistry registry) {
        this.compositeRegistry.add(registry);
    }

    protected ApplicationModel getApplicationModel() {
        return this.applicationModel;
    }

    private void addJvmMetrics() {
        boolean enableJvmMetrics = this.url.getParameter("enable.jvm", false);
        if (enableJvmMetrics) {
            new ClassLoaderMetrics().bindTo((MeterRegistry)this.compositeRegistry);
            new JvmMemoryMetrics().bindTo((MeterRegistry)this.compositeRegistry);
            JvmGcMetrics jvmGcMetrics = new JvmGcMetrics();
            jvmGcMetrics.bindTo((MeterRegistry)this.compositeRegistry);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> ((JvmGcMetrics)jvmGcMetrics).close()));
            this.bindTo((MeterBinder)new ProcessorMetrics());
            new JvmThreadMetrics().bindTo((MeterRegistry)this.compositeRegistry);
            this.bindTo((MeterBinder)new UptimeMetrics());
        }
    }

    private void bindTo(MeterBinder binder) {
        binder.bindTo((MeterRegistry)this.compositeRegistry);
        this.instanceHolder.add(binder);
    }

    private void initCollectors() {
        ScopeBeanFactory beanFactory = this.applicationModel.getBeanFactory();
        beanFactory.getOrRegisterBean(AggregateMetricsCollector.class);
        beanFactory.getOrRegisterBean(HistogramMetricsCollector.class);
        List<MetricsCollector> otherCollectors = beanFactory.getBeansOfType(MetricsCollector.class);
        this.collectors.addAll(otherCollectors);
    }

    private void scheduleMetricsCollectorSyncJob() {
        boolean enableCollectorSync = this.url.getParameter("enable.collector.sync", true);
        if (enableCollectorSync) {
            NamedThreadFactory threadFactory = new NamedThreadFactory("metrics-collector-sync-job", true);
            this.collectorSyncJobExecutor = Executors.newScheduledThreadPool(1, threadFactory);
            this.collectorSyncJobExecutor.scheduleWithFixedDelay(this::refreshData, 5L, 3L, TimeUnit.SECONDS);
        }
    }

    @Override
    public void refreshData() {
        this.collectors.forEach(collector -> {
            List<MetricSample> samples = collector.collect();
            for (MetricSample sample : samples) {
                try {
                    switch (sample.getType()) {
                        case GAUGE: {
                            GaugeMetricSample gaugeSample = (GaugeMetricSample)sample;
                            List<Tag> tags = AbstractMetricsReporter.getTags(gaugeSample);
                            Gauge.builder((String)gaugeSample.getName(), gaugeSample.getValue(), gaugeSample.getApply()).description(gaugeSample.getDescription()).tags(tags).register((MeterRegistry)this.compositeRegistry);
                            break;
                        }
                        case COUNTER: {
                            CounterMetricSample counterMetricSample = (CounterMetricSample)sample;
                            FunctionCounter.builder((String)counterMetricSample.getName(), counterMetricSample.getValue(), Number::doubleValue).description(counterMetricSample.getDescription()).tags(AbstractMetricsReporter.getTags(counterMetricSample)).register((MeterRegistry)this.compositeRegistry);
                        }
                        case TIMER: 
                        case LONG_TASK_TIMER: 
                        case DISTRIBUTION_SUMMARY: {
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    this.logger.error("0-13", "", "", "error occurred when synchronize metrics collector.", e);
                }
            }
        });
    }

    private static List<Tag> getTags(MetricSample gaugeSample) {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        gaugeSample.getTags().forEach((k, v) -> {
            if (v == null) {
                v = "";
            }
            tags.add(Tag.of((String)k, (String)v));
        });
        return tags;
    }

    private void registerDubboShutdownHook() {
        this.applicationModel.getBeanFactory().getBean(ShutdownHookCallbacks.class).addCallback(this::destroy);
    }

    public void destroy() {
        if (this.collectorSyncJobExecutor != null) {
            this.collectorSyncJobExecutor.shutdownNow();
        }
        this.doDestroy();
    }

    protected abstract void doInit();

    protected abstract void doDestroy();
}

