/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.registry.collector;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.config.context.ConfigManager;
import org.apache.dubbo.metrics.collector.CombMetricsCollector;
import org.apache.dubbo.metrics.data.ApplicationStatComposite;
import org.apache.dubbo.metrics.data.BaseStatComposite;
import org.apache.dubbo.metrics.data.RtStatComposite;
import org.apache.dubbo.metrics.data.ServiceStatComposite;
import org.apache.dubbo.metrics.model.MetricsCategory;
import org.apache.dubbo.metrics.model.sample.MetricSample;
import org.apache.dubbo.metrics.registry.NettyMetricsConstants;
import org.apache.dubbo.metrics.registry.event.NettyEvent;
import org.apache.dubbo.metrics.registry.event.NettySubDispatcher;
import org.apache.dubbo.rpc.model.ApplicationModel;

@Activate
public class NettyMetricsCollector
extends CombMetricsCollector<NettyEvent> {
    private Boolean collectEnabled = null;
    private final ApplicationModel applicationModel;

    public NettyMetricsCollector(ApplicationModel applicationModel) {
        super(new BaseStatComposite(applicationModel){

            @Override
            protected void init(ApplicationStatComposite applicationStatComposite) {
                super.init(applicationStatComposite);
                applicationStatComposite.init(NettyMetricsConstants.APP_LEVEL_KEYS);
            }

            @Override
            protected void init(ServiceStatComposite serviceStatComposite) {
                super.init(serviceStatComposite);
            }

            @Override
            protected void init(RtStatComposite rtStatComposite) {
                super.init(rtStatComposite);
            }
        });
        super.setEventMulticaster(new NettySubDispatcher(this));
        this.applicationModel = applicationModel;
    }

    public void setCollectEnabled(Boolean collectEnabled) {
        if (collectEnabled != null) {
            this.collectEnabled = collectEnabled;
        }
    }

    @Override
    public boolean isCollectEnabled() {
        if (this.collectEnabled == null) {
            ConfigManager configManager = this.applicationModel.getApplicationConfigManager();
            configManager.getMetrics().ifPresent(metricsConfig -> this.setCollectEnabled(metricsConfig.getEnableNetty()));
        }
        return Optional.ofNullable(this.collectEnabled).orElse(true);
    }

    @Override
    public List<MetricSample> collect() {
        ArrayList<MetricSample> list = new ArrayList<MetricSample>();
        if (!this.isCollectEnabled()) {
            return list;
        }
        list.addAll(super.export(MetricsCategory.NETTY));
        return list;
    }
}

