/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.metrics.model.Metric;

public class ConfigCenterMetric
implements Metric {
    private String applicationName;
    private String key;
    private String group;
    private String configCenter;
    private String changeType;

    public ConfigCenterMetric() {
    }

    public ConfigCenterMetric(String applicationName, String key, String group, String configCenter, String changeType) {
        this.applicationName = applicationName;
        this.key = key;
        this.group = group;
        this.configCenter = configCenter;
        this.changeType = changeType;
    }

    @Override
    public Map<String, String> getTags() {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("ip", NetUtils.getLocalHost());
        tags.put("hostname", NetUtils.getLocalHostName());
        tags.put("application.name", this.applicationName);
        tags.put("key", this.key);
        tags.put("group", this.group);
        tags.put("config.center", this.configCenter);
        tags.put("change.type", this.changeType.toLowerCase());
        return tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigCenterMetric that = (ConfigCenterMetric)o;
        if (!Objects.equals(this.applicationName, that.applicationName)) {
            return false;
        }
        if (!Objects.equals(this.key, that.key)) {
            return false;
        }
        if (!Objects.equals(this.group, that.group)) {
            return false;
        }
        if (!Objects.equals(this.configCenter, that.configCenter)) {
            return false;
        }
        return Objects.equals(this.changeType, that.changeType);
    }

    public int hashCode() {
        return Objects.hash(this.applicationName, this.key, this.group, this.configCenter, this.changeType);
    }
}

