/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.rest.springmvc;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.utils.AnnotationUtils;
import org.apache.dubbo.common.utils.ArrayUtils;
import org.apache.dubbo.common.utils.MethodUtils;
import org.apache.dubbo.common.utils.PathUtils;
import org.apache.dubbo.metadata.rest.AbstractServiceRestMetadataResolver;
import org.apache.dubbo.metadata.rest.RestMetadataConstants;
import org.apache.dubbo.rpc.model.ApplicationModel;

@Activate(order=100)
public class SpringMvcServiceRestMetadataResolver
extends AbstractServiceRestMetadataResolver {
    private static final int FIRST_ELEMENT_INDEX = 0;

    public SpringMvcServiceRestMetadataResolver(ApplicationModel applicationModel) {
        super(applicationModel);
    }

    @Override
    protected boolean supports0(Class<?> serviceType) {
        return AnnotationUtils.isAnnotationPresent(serviceType, RestMetadataConstants.SPRING_MVC.CONTROLLER_ANNOTATION_CLASS) || AnnotationUtils.isAnnotationPresent(serviceType, RestMetadataConstants.SPRING_MVC.FEIGN_CLIENT_CLASS) || AnnotationUtils.isAnnotationPresent(serviceType, RestMetadataConstants.SPRING_MVC.REQUEST_MAPPING_ANNOTATION_CLASS) || SpringMvcServiceRestMetadataResolver.isServiceMethodAnnotationPresent(serviceType, "org.springframework.web.bind.annotation.RequestMapping");
    }

    @Override
    protected boolean isRestCapableMethod(Method serviceMethod, Class<?> serviceType, Class<?> serviceInterfaceClass) {
        return AnnotationUtils.isAnnotationPresent((AnnotatedElement)serviceMethod, RestMetadataConstants.SPRING_MVC.REQUEST_MAPPING_ANNOTATION_CLASS);
    }

    @Override
    protected String resolveRequestMethod(Method serviceMethod, Class<?> serviceType, Class<?> serviceInterfaceClass) {
        Annotation requestMapping = this.getRequestMapping(serviceMethod);
        Object httpMethod = AnnotationUtils.getAttribute(requestMapping, "method");
        if (httpMethod == null || Array.getLength(httpMethod) < 1) {
            return null;
        }
        return String.valueOf(Array.get(httpMethod, 0));
    }

    @Override
    protected String resolveRequestPath(Method serviceMethod, Class<?> serviceType, Class<?> serviceInterfaceClass) {
        String feignClientBasePath = this.resolveFeignClientBaseRequestPath(serviceType);
        String requestMappingBasePath = this.resolveRequestPath(serviceType);
        String requestRelativePath = this.resolveRequestPath(serviceMethod);
        return PathUtils.buildPath(feignClientBasePath, PathUtils.buildPath(requestMappingBasePath, requestRelativePath));
    }

    @Override
    protected void processProduces(Method serviceMethod, Class<?> serviceType, Class<?> serviceInterfaceClass, Set<String> produces) {
        this.addMediaTypes(serviceMethod, "produces", produces);
        this.addMediaTypes(serviceType, "produces", produces);
        this.addMediaTypes(serviceInterfaceClass, "produces", produces);
    }

    @Override
    protected void processConsumes(Method serviceMethod, Class<?> serviceType, Class<?> serviceInterfaceClass, Set<String> consumes) {
        this.addMediaTypes(serviceMethod, "consumes", consumes);
        this.addMediaTypes(serviceType, "consumes", consumes);
        this.addMediaTypes(serviceInterfaceClass, "consumes", consumes);
    }

    private String resolveFeignClientBaseRequestPath(AnnotatedElement annotatedElement) {
        Annotation feignClient = AnnotationUtils.findAnnotation(annotatedElement, RestMetadataConstants.SPRING_MVC.FEIGN_CLIENT_CLASS);
        String path = (String)AnnotationUtils.getAttribute(feignClient, "path");
        if (path == null) {
            return "";
        }
        return path;
    }

    private String resolveRequestPath(AnnotatedElement annotatedElement) {
        Annotation mappingAnnotation = this.getRequestMapping(annotatedElement);
        Object[] value = (String[])AnnotationUtils.getAttribute(mappingAnnotation, "value");
        if (ArrayUtils.isEmpty(value)) {
            value = (String[])AnnotationUtils.getAttribute(mappingAnnotation, "path");
        }
        if (ArrayUtils.isEmpty(value)) {
            return "";
        }
        return value[0];
    }

    private void addMediaTypes(Method serviceMethod, String annotationAttributeName, Set<String> mediaTypesSet) {
        Annotation mappingAnnotation = this.getRequestMapping(serviceMethod);
        Object[] mediaTypes = (String[])AnnotationUtils.getAttribute(mappingAnnotation, annotationAttributeName);
        if (ArrayUtils.isNotEmpty(mediaTypes)) {
            Stream.of(mediaTypes).forEach(mediaTypesSet::add);
        }
    }

    private void addMediaTypes(Class serviceType, String annotationAttributeName, Set<String> mediaTypesSet) {
        Annotation mappingAnnotation = this.getRequestMapping(serviceType);
        Object[] mediaTypes = (String[])AnnotationUtils.getAttribute(mappingAnnotation, annotationAttributeName);
        if (ArrayUtils.isNotEmpty(mediaTypes)) {
            Stream.of(mediaTypes).forEach(mediaTypesSet::add);
        }
    }

    private Annotation getRequestMapping(AnnotatedElement annotatedElement) {
        Method method;
        Annotation requestMapping = AnnotationUtils.findAnnotation(annotatedElement, RestMetadataConstants.SPRING_MVC.REQUEST_MAPPING_ANNOTATION_CLASS);
        if (requestMapping == null && (method = MethodUtils.findMethod(RestMetadataConstants.SPRING_MVC.ANNOTATED_ELEMENT_UTILS_CLASS, "findMergedAnnotation", AnnotatedElement.class, Class.class)) != null) {
            try {
                requestMapping = (Annotation)method.invoke(null, annotatedElement, RestMetadataConstants.SPRING_MVC.REQUEST_MAPPING_ANNOTATION_CLASS);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return requestMapping;
    }
}

