/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.rest.noannotaion;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Set;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.utils.PathUtils;
import org.apache.dubbo.metadata.rest.AbstractServiceRestMetadataResolver;
import org.apache.dubbo.metadata.rest.ArgInfo;
import org.apache.dubbo.metadata.rest.RestMethodMetadata;
import org.apache.dubbo.metadata.rest.media.MediaType;
import org.apache.dubbo.rpc.model.ApplicationModel;

@Activate(order=0x7FFFFFFF)
public class NoAnnotationServiceRestMetadataResolver
extends AbstractServiceRestMetadataResolver {
    private static final String CONTENT_TYPE = MediaType.APPLICATION_JSON_VALUE.value;
    private static final String REQUEST_METHOD = "POST";

    public NoAnnotationServiceRestMetadataResolver(ApplicationModel applicationModel) {
        super(applicationModel);
    }

    @Override
    protected boolean supports0(Class<?> serviceType) {
        return true;
    }

    @Override
    protected boolean isRestCapableMethod(Method serviceMethod, Class<?> serviceType, Class<?> serviceInterfaceClass) {
        return true;
    }

    @Override
    protected String resolveRequestMethod(Method serviceMethod, Class<?> serviceType, Class<?> serviceInterfaceClass) {
        return REQUEST_METHOD;
    }

    @Override
    protected String resolveRequestPath(Method serviceMethod, Class<?> serviceType, Class<?> serviceInterfaceClass) {
        return PathUtils.buildPath(serviceInterfaceClass.getName(), serviceMethod.getName());
    }

    @Override
    protected void processProduces(Method serviceMethod, Class<?> serviceType, Class<?> serviceInterfaceClass, Set<String> produces) {
        produces.add(CONTENT_TYPE);
    }

    @Override
    protected void processConsumes(Method serviceMethod, Class<?> serviceType, Class<?> serviceInterfaceClass, Set<String> consumes) {
        consumes.add(CONTENT_TYPE);
    }

    @Override
    protected void processAnnotatedMethodParameter(Parameter parameter, int parameterIndex, Method serviceMethod, Class<?> serviceType, Class<?> serviceInterfaceClass, RestMethodMetadata metadata) {
        ArgInfo argInfo = ArgInfo.build(parameterIndex, parameter);
        metadata.addArgInfo(argInfo);
    }
}

