/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring;

import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.bytecode.Proxy;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.Assert;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.spring.aot.AotWithSpringDetector;
import org.apache.dubbo.config.spring.context.DubboConfigApplicationListener;
import org.apache.dubbo.config.spring.reference.ReferenceBeanManager;
import org.apache.dubbo.config.spring.reference.ReferenceBeanSupport;
import org.apache.dubbo.config.spring.util.LazyTargetInvocationHandler;
import org.apache.dubbo.config.spring.util.LazyTargetSource;
import org.apache.dubbo.config.spring.util.LockUtils;
import org.apache.dubbo.config.support.Parameter;
import org.apache.dubbo.rpc.proxy.AbstractProxyFactory;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ReferenceBean<T>
implements FactoryBean<T>,
ApplicationContextAware,
BeanClassLoaderAware,
BeanNameAware,
InitializingBean,
DisposableBean {
    private final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(this.getClass());
    private transient ApplicationContext applicationContext;
    private ClassLoader beanClassLoader;
    private Object lazyProxy;
    protected String id;
    private String key;
    private Class<?> interfaceClass;
    private String interfaceName;
    private String proxy;
    private Map<String, Object> referenceProps;
    private MutablePropertyValues propertyValues;
    private ReferenceConfig referenceConfig;
    private ReferenceBeanManager referenceBeanManager;
    private List<Map<String, Object>> sources = new ArrayList<Map<String, Object>>();

    public ReferenceBean() {
    }

    public ReferenceBean(Map<String, Object> referenceProps) {
        this.referenceProps = referenceProps;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public void setBeanName(String name) {
        this.setId(name);
    }

    public T getObject() {
        if (this.lazyProxy == null) {
            this.createLazyProxy();
        }
        return (T)this.lazyProxy;
    }

    public Class<?> getObjectType() {
        return this.getInterfaceClass();
    }

    @Parameter(excluded=true)
    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        ConfigurableListableBeanFactory beanFactory = this.getBeanFactory();
        Assert.notEmptyString(this.getId(), "The id of ReferenceBean cannot be empty");
        BeanDefinition beanDefinition = beanFactory.getBeanDefinition(this.getId());
        if (AotWithSpringDetector.useGeneratedArtifacts()) {
            this.interfaceClass = (Class)beanDefinition.getPropertyValues().get("interfaceClass");
            this.interfaceName = (String)beanDefinition.getPropertyValues().get("interfaceName");
        } else {
            this.interfaceClass = (Class)beanDefinition.getAttribute("interfaceClass");
            this.interfaceName = (String)beanDefinition.getAttribute("interfaceName");
        }
        Assert.notNull(this.interfaceClass, "The interface class of ReferenceBean is not initialized");
        if (beanDefinition.hasAttribute("referenceProps")) {
            this.referenceProps = (Map)beanDefinition.getAttribute("referenceProps");
        } else if (beanDefinition instanceof AnnotatedBeanDefinition) {
            if (this.referenceProps == null) {
                this.referenceProps = new LinkedHashMap<String, Object>();
            }
            ReferenceBeanSupport.convertReferenceProps(this.referenceProps, this.interfaceClass);
            if (this.interfaceName == null) {
                this.interfaceName = (String)this.referenceProps.get("interface");
            }
        } else {
            this.propertyValues = beanDefinition.getPropertyValues();
        }
        if (this.referenceProps != null) {
            this.proxy = (String)this.referenceProps.get("proxy");
        }
        Assert.notNull((Object)this.interfaceName, "The interface name of ReferenceBean is not initialized");
        this.referenceBeanManager = (ReferenceBeanManager)beanFactory.getBean("dubboReferenceBeanManager", ReferenceBeanManager.class);
        this.referenceBeanManager.addReference(this);
    }

    private ConfigurableListableBeanFactory getBeanFactory() {
        return (ConfigurableListableBeanFactory)this.applicationContext.getAutowireCapableBeanFactory();
    }

    public void destroy() {
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Class<?> getInterfaceClass() {
        return this.interfaceClass;
    }

    public String getServiceInterface() {
        return this.interfaceName;
    }

    public String getGroup() {
        return this.referenceConfig.getGroup();
    }

    public String getVersion() {
        return this.referenceConfig.getVersion();
    }

    public String getKey() {
        return this.key;
    }

    public Map<String, Object> getReferenceProps() {
        return this.referenceProps;
    }

    public MutablePropertyValues getPropertyValues() {
        return this.propertyValues;
    }

    public ReferenceConfig getReferenceConfig() {
        return this.referenceConfig;
    }

    public void setKeyAndReferenceConfig(String key, ReferenceConfig referenceConfig) {
        this.key = key;
        this.referenceConfig = referenceConfig;
    }

    private void createLazyProxy() {
        ArrayList interfaces = new ArrayList();
        interfaces.add(this.interfaceClass);
        Class<?>[] internalInterfaces = AbstractProxyFactory.getInternalInterfaces();
        Collections.addAll(interfaces, internalInterfaces);
        if (!StringUtils.isEquals(this.interfaceClass.getName(), this.interfaceName)) {
            try {
                Class<?> serviceInterface = ClassUtils.forName(this.interfaceName, this.beanClassLoader);
                interfaces.add(serviceInterface);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (StringUtils.isEmpty(this.proxy) || "javassist".equalsIgnoreCase(this.proxy)) {
            this.generateFromJavassistFirst(interfaces);
        }
        if (this.lazyProxy == null) {
            this.generateFromJdk(interfaces);
        }
    }

    private void generateFromJavassistFirst(List<Class<?>> interfaces) {
        try {
            this.lazyProxy = Proxy.getProxy(interfaces.toArray(new Class[0])).newInstance(new LazyTargetInvocationHandler(new DubboReferenceLazyInitTargetSource()));
        }
        catch (Throwable fromJavassist) {
            try {
                this.lazyProxy = java.lang.reflect.Proxy.newProxyInstance(this.beanClassLoader, interfaces.toArray(new Class[0]), (InvocationHandler)new LazyTargetInvocationHandler(new DubboReferenceLazyInitTargetSource()));
                this.logger.error("3-8", "", "", "Failed to generate proxy by Javassist failed. Fallback to use JDK proxy success. Interfaces: " + interfaces, fromJavassist);
            }
            catch (Throwable fromJdk) {
                this.logger.error("3-8", "", "", "Failed to generate proxy by Javassist failed. Fallback to use JDK proxy is also failed. Interfaces: " + interfaces + " Javassist Error.", fromJavassist);
                this.logger.error("3-8", "", "", "Failed to generate proxy by Javassist failed. Fallback to use JDK proxy is also failed. Interfaces: " + interfaces + " JDK Error.", fromJdk);
                throw fromJavassist;
            }
        }
    }

    private void generateFromJdk(List<Class<?>> interfaces) {
        try {
            this.lazyProxy = java.lang.reflect.Proxy.newProxyInstance(this.beanClassLoader, interfaces.toArray(new Class[0]), (InvocationHandler)new LazyTargetInvocationHandler(new DubboReferenceLazyInitTargetSource()));
        }
        catch (Throwable fromJdk) {
            this.logger.error("3-8", "", "", "Failed to generate proxy by Javassist failed. Fallback to use JDK proxy is also failed. Interfaces: " + interfaces + " JDK Error.", fromJdk);
            throw fromJdk;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getCallProxy() throws Exception {
        if (this.referenceConfig == null) {
            this.referenceBeanManager.initReferenceBean(this);
            ((DubboConfigApplicationListener)this.applicationContext.getBean(DubboConfigApplicationListener.class.getName(), DubboConfigApplicationListener.class)).init();
            this.logger.warn("5-39", "", "", "ReferenceBean is not ready yet, please make sure to call reference interface method after dubbo is started.");
        }
        if (this.referenceConfig.configInitialized()) {
            return this.referenceConfig.get();
        }
        Object object = LockUtils.getSingletonMutex(this.applicationContext);
        synchronized (object) {
            return this.referenceConfig.get();
        }
    }

    public void setInterfaceClass(Class<?> interfaceClass) {
        this.interfaceClass = interfaceClass;
    }

    public void setInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
    }

    private class DubboReferenceLazyInitTargetSource
    implements LazyTargetSource {
        private DubboReferenceLazyInitTargetSource() {
        }

        @Override
        public Object getTarget() throws Exception {
            return ReferenceBean.this.getCallProxy();
        }
    }
}

