/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config;

import java.beans.Transient;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.aot.NativeDetector;
import org.apache.dubbo.common.compiler.support.AdaptiveCompiler;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.config.Environment;
import org.apache.dubbo.common.config.InmemoryConfiguration;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.utils.Assert;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.ConfigUtils;
import org.apache.dubbo.common.utils.ReflectUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.AbstractMethodConfig;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ArgumentConfig;
import org.apache.dubbo.config.ConfigCenterConfig;
import org.apache.dubbo.config.MetadataReportConfig;
import org.apache.dubbo.config.MethodConfig;
import org.apache.dubbo.config.MetricsConfig;
import org.apache.dubbo.config.ModuleConfig;
import org.apache.dubbo.config.MonitorConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.SslConfig;
import org.apache.dubbo.config.support.Parameter;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.model.ScopeModelUtil;
import org.apache.dubbo.rpc.model.ServiceMetadata;

public abstract class AbstractInterfaceConfig
extends AbstractMethodConfig {
    private static final long serialVersionUID = -1559314110797223229L;
    protected String interfaceName;
    protected transient ClassLoader interfaceClassLoader;
    protected String version;
    protected String group;
    protected ServiceMetadata serviceMetadata;
    protected String local;
    protected String stub;
    protected MonitorConfig monitor;
    protected String proxy;
    protected String cluster;
    protected String filter;
    protected String listener;
    protected String owner;
    protected Integer connections;
    protected String layer;
    protected ApplicationConfig application;
    protected ModuleConfig module;
    protected List<RegistryConfig> registries;
    private List<MethodConfig> methods;
    protected String registryIds;
    protected String onconnect;
    protected String ondisconnect;
    protected MetadataReportConfig metadataReportConfig;
    protected ConfigCenterConfig configCenter;
    private Integer callbacks;
    private String scope;
    protected String tag;
    private Boolean auth;
    private Boolean singleton;
    protected final transient List<URL> urls = new ArrayList<URL>();

    public AbstractInterfaceConfig() {
    }

    public AbstractInterfaceConfig(ModuleModel moduleModel) {
        super(moduleModel);
    }

    @Transient
    public List<URL> getExportedUrls() {
        return this.urls;
    }

    public URL toUrl() {
        return this.urls.isEmpty() ? null : this.urls.iterator().next();
    }

    public List<URL> toUrls() {
        return this.urls;
    }

    @Override
    protected void postProcessAfterScopeModelChanged(ScopeModel oldScopeModel, ScopeModel newScopeModel) {
        super.postProcessAfterScopeModelChanged(oldScopeModel, newScopeModel);
        ApplicationModel applicationModel = ScopeModelUtil.getApplicationModel(this.getScopeModel());
        if (this.configCenter != null && this.configCenter.getScopeModel() != applicationModel) {
            this.configCenter.setScopeModel(applicationModel);
        }
        if (this.metadataReportConfig != null && this.metadataReportConfig.getScopeModel() != applicationModel) {
            this.metadataReportConfig.setScopeModel(applicationModel);
        }
        if (this.monitor != null && this.monitor.getScopeModel() != applicationModel) {
            this.monitor.setScopeModel(applicationModel);
        }
        if (CollectionUtils.isNotEmpty(this.registries)) {
            this.registries.forEach(registryConfig -> {
                if (registryConfig.getScopeModel() != applicationModel) {
                    registryConfig.setScopeModel(applicationModel);
                }
            });
        }
    }

    protected void checkRegistry() {
        this.convertRegistryIdsToRegistries();
        for (RegistryConfig registryConfig : this.registries) {
            if (registryConfig.isValid()) continue;
            throw new IllegalStateException("No registry config found or it's not a valid config! The registry config is: " + registryConfig);
        }
    }

    public static void appendRuntimeParameters(Map<String, String> map) {
        map.put("dubbo", Version.getProtocolVersion());
        map.put("release", Version.getVersion());
        map.put("timestamp", String.valueOf(System.currentTimeMillis()));
        if (ConfigUtils.getPid() > 0) {
            map.put("pid", String.valueOf(ConfigUtils.getPid()));
        }
    }

    @Deprecated
    protected void appendMetricsCompatible(Map<String, String> map) {
        String protocol;
        MetricsConfig metricsConfig = this.getConfigManager().getMetrics().orElse(null);
        if (metricsConfig != null && !StringUtils.isEquals(protocol = Optional.ofNullable(metricsConfig.getProtocol()).orElse("prometheus"), "prometheus")) {
            Assert.notEmptyString(metricsConfig.getPort(), "Metrics port cannot be null");
            map.put("metrics.protocol", protocol);
            map.put("metrics.port", metricsConfig.getPort());
        }
    }

    protected String[] methods(Class<?> interfaceClass) {
        if (NativeDetector.inNativeImage()) {
            return (String[])Arrays.stream(interfaceClass.getMethods()).map(Method::getName).toArray(String[]::new);
        }
        return ClassUtils.getMethodNames(interfaceClass);
    }

    protected Environment getEnvironment() {
        return this.getScopeModel().modelEnvironment();
    }

    @Override
    protected void processExtraRefresh(String preferredPrefix, InmemoryConfiguration subPropsConfiguration) {
        if (StringUtils.hasText(this.interfaceName)) {
            Method[] methods;
            Class<?> interfaceClass;
            try {
                interfaceClass = ClassUtils.forName(this.interfaceName);
            }
            catch (ClassNotFoundException e) {
                return;
            }
            if (!interfaceClass.isInterface() && !this.canSkipInterfaceCheck()) {
                throw new IllegalStateException(this.interfaceName + " is not an interface");
            }
            Map<String, String> configProperties = subPropsConfiguration.getProperties();
            try {
                methods = interfaceClass.getMethods();
            }
            catch (Throwable e) {
                return;
            }
            for (Method method : methods) {
                if (!ConfigurationUtils.hasSubProperties(configProperties, method.getName())) continue;
                MethodConfig methodConfig2 = this.getMethodByName(method.getName());
                if (methodConfig2 == null) {
                    methodConfig2 = new MethodConfig();
                    methodConfig2.setName(method.getName());
                    this.addMethod(methodConfig2);
                }
                java.lang.reflect.Parameter[] arguments = method.getParameters();
                for (int i = 0; i < arguments.length; ++i) {
                    if (this.getArgumentByIndex(methodConfig2, i) != null || !this.hasArgumentConfigProps(configProperties, methodConfig2.getName(), i)) continue;
                    ArgumentConfig argumentConfig = new ArgumentConfig();
                    argumentConfig.setIndex(i);
                    methodConfig2.addArgument(argumentConfig);
                }
            }
            List<MethodConfig> methodConfigs = this.getMethods();
            if (methodConfigs != null && methodConfigs.size() > 0) {
                Object ignoreInvalidMethodConfigVal = this.getEnvironment().getConfiguration().getProperty("dubbo.config.ignore-invalid-method-config", "false");
                boolean ignoreInvalidMethodConfig = Boolean.parseBoolean(ignoreInvalidMethodConfigVal.toString());
                Class<?> finalInterfaceClass = interfaceClass;
                List validMethodConfigs = methodConfigs.stream().filter(methodConfig -> {
                    methodConfig.setParentPrefix(preferredPrefix);
                    methodConfig.setScopeModel(this.getScopeModel());
                    methodConfig.refresh();
                    return this.verifyMethodConfig((MethodConfig)methodConfig, finalInterfaceClass, ignoreInvalidMethodConfig);
                }).collect(Collectors.toList());
                this.setMethods(validMethodConfigs);
            }
        }
    }

    protected boolean canSkipInterfaceCheck() {
        return false;
    }

    protected boolean verifyMethodConfig(MethodConfig methodConfig, Class<?> interfaceClass, boolean ignoreInvalidMethodConfig) {
        String methodName = methodConfig.getName();
        if (StringUtils.isEmpty(methodName)) {
            String msg = "<dubbo:method> name attribute is required! Please check: <dubbo:service interface=\"" + this.interfaceName + "\" ... ><dubbo:method name=\"\" ... /></<dubbo:reference>";
            if (ignoreInvalidMethodConfig) {
                logger.warn("5-4", "", "", msg);
                return false;
            }
            throw new IllegalStateException(msg);
        }
        boolean hasMethod = Arrays.stream(interfaceClass.getMethods()).anyMatch(method -> method.getName().equals(methodName));
        if (!hasMethod) {
            String msg = "Found invalid method config, the interface " + interfaceClass.getName() + " not found method \"" + methodName + "\" : [" + methodConfig + "]";
            if (ignoreInvalidMethodConfig) {
                logger.warn("5-4", "", "", msg);
                return false;
            }
            if (!this.isNeedCheckMethod()) {
                msg = "Generic call: " + msg;
                logger.warn("5-4", "", "", msg);
            } else {
                throw new IllegalStateException(msg);
            }
        }
        return true;
    }

    private ArgumentConfig getArgumentByIndex(MethodConfig methodConfig, int argIndex) {
        if (methodConfig.getArguments() != null && methodConfig.getArguments().size() > 0) {
            for (ArgumentConfig argument : methodConfig.getArguments()) {
                if (argument.getIndex() == null || argument.getIndex() != argIndex) continue;
                return argument;
            }
        }
        return null;
    }

    @Transient
    protected boolean isNeedCheckMethod() {
        return true;
    }

    private boolean hasArgumentConfigProps(Map<String, String> configProperties, String methodName, int argIndex) {
        String argPrefix = methodName + "." + argIndex + ".";
        return ConfigurationUtils.hasSubProperties(configProperties, argPrefix);
    }

    protected MethodConfig getMethodByName(String name) {
        if (this.methods != null && this.methods.size() > 0) {
            for (MethodConfig methodConfig : this.methods) {
                if (!StringUtils.isEquals(methodConfig.getName(), name)) continue;
                return methodConfig;
            }
        }
        return null;
    }

    protected void checkStubAndLocal(Class<?> interfaceClass) {
        this.verifyStubAndLocal(this.local, "Local", interfaceClass);
        this.verifyStubAndLocal(this.stub, "Stub", interfaceClass);
    }

    private void verifyStubAndLocal(String className, String label, Class<?> interfaceClass) {
        if (ConfigUtils.isNotEmpty(className)) {
            Class<?> localClass = ConfigUtils.isDefault(className) ? ReflectUtils.forName(interfaceClass.getName() + label) : ReflectUtils.forName(className);
            this.verify(interfaceClass, localClass);
        }
    }

    private void verify(Class<?> interfaceClass, Class<?> localClass) {
        if (!interfaceClass.isAssignableFrom(localClass)) {
            throw new IllegalStateException("The local implementation class " + localClass.getName() + " not implement interface " + interfaceClass.getName());
        }
        try {
            ReflectUtils.findConstructor(localClass, interfaceClass);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("No such constructor \"public " + localClass.getSimpleName() + "(" + interfaceClass.getName() + ")\" in local implementation class " + localClass.getName());
        }
    }

    private void convertRegistryIdsToRegistries() {
        this.computeValidRegistryIds();
        if (StringUtils.isEmpty(this.registryIds)) {
            if (CollectionUtils.isEmpty(this.registries)) {
                List<RegistryConfig> registryConfigs = this.getConfigManager().getDefaultRegistries();
                registryConfigs = new ArrayList<RegistryConfig>(registryConfigs);
                this.setRegistries(registryConfigs);
            }
        } else {
            String[] ids = CommonConstants.COMMA_SPLIT_PATTERN.split(this.registryIds);
            ArrayList tmpRegistries = new ArrayList();
            Arrays.stream(ids).forEach(id -> {
                if (tmpRegistries.stream().noneMatch(reg -> reg.getId().equals(id))) {
                    Optional<RegistryConfig> globalRegistry = this.getConfigManager().getRegistry((String)id);
                    if (globalRegistry.isPresent()) {
                        tmpRegistries.add(globalRegistry.get());
                    } else {
                        throw new IllegalStateException("Registry not found: " + id);
                    }
                }
            });
            this.setRegistries(tmpRegistries);
        }
    }

    protected boolean notHasSelfRegistryProperty() {
        return CollectionUtils.isEmpty(this.registries) && StringUtils.isEmpty(this.registryIds);
    }

    protected void completeCompoundConfigs(AbstractInterfaceConfig interfaceConfig) {
        if (interfaceConfig != null) {
            if (this.application == null) {
                this.setApplication(interfaceConfig.getApplication());
            }
            if (this.module == null) {
                this.setModule(interfaceConfig.getModule());
            }
            if (this.notHasSelfRegistryProperty()) {
                this.setRegistries(interfaceConfig.getRegistries());
                this.setRegistryIds(interfaceConfig.getRegistryIds());
            }
            if (this.monitor == null) {
                this.setMonitor(interfaceConfig.getMonitor());
            }
        }
        if (this.module != null) {
            if (this.notHasSelfRegistryProperty()) {
                this.setRegistries(this.module.getRegistries());
            }
            if (this.monitor == null) {
                this.setMonitor(this.module.getMonitor());
            }
        }
        if (this.application != null) {
            if (this.notHasSelfRegistryProperty()) {
                this.setRegistries(this.application.getRegistries());
                this.setRegistryIds(this.application.getRegistryIds());
            }
            if (this.monitor == null) {
                this.setMonitor(this.application.getMonitor());
            }
        }
    }

    protected void computeValidRegistryIds() {
        if (this.application != null && this.notHasSelfRegistryProperty()) {
            this.setRegistries(this.application.getRegistries());
            this.setRegistryIds(this.application.getRegistryIds());
        }
    }

    @Deprecated
    public String getLocal() {
        return this.local;
    }

    @Deprecated
    public void setLocal(Boolean local) {
        if (local == null) {
            this.setLocal((String)null);
        } else {
            this.setLocal(local.toString());
        }
    }

    @Deprecated
    public void setLocal(String local) {
        this.local = local;
    }

    public String getStub() {
        return this.stub;
    }

    public void setStub(Boolean stub) {
        if (stub == null) {
            this.setStub((String)null);
        } else {
            this.setStub(stub.toString());
        }
    }

    public void setStub(String stub) {
        this.stub = stub;
    }

    public String getCluster() {
        return this.cluster;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public String getProxy() {
        if (NativeDetector.inNativeImage()) {
            return "jdk";
        }
        return this.proxy;
    }

    public void setProxy(String proxy) {
        if (NativeDetector.inNativeImage()) {
            this.proxy = "jdk";
            AdaptiveCompiler.setDefaultCompiler("jdk");
        } else {
            this.proxy = proxy;
        }
    }

    public Integer getConnections() {
        return this.connections;
    }

    public void setConnections(Integer connections) {
        this.connections = connections;
    }

    @Parameter(key="reference.filter", append=true)
    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    @Parameter(key="invoker.listener", append=true)
    public String getListener() {
        return this.listener;
    }

    public void setListener(String listener) {
        this.listener = listener;
    }

    public String getLayer() {
        return this.layer;
    }

    public void setLayer(String layer) {
        this.layer = layer;
    }

    public ApplicationConfig getApplication() {
        if (this.application != null) {
            return this.application;
        }
        return this.getConfigManager().getApplicationOrElseThrow();
    }

    @Deprecated
    public void setApplication(ApplicationConfig application) {
        this.application = application;
        if (application != null) {
            this.getConfigManager().setApplication(application);
        }
    }

    public ModuleConfig getModule() {
        if (this.module != null) {
            return this.module;
        }
        return this.getModuleConfigManager().getModule().orElse(null);
    }

    @Deprecated
    public void setModule(ModuleConfig module) {
        this.module = module;
        if (module != null) {
            this.getModuleConfigManager().setModule(module);
        }
    }

    public RegistryConfig getRegistry() {
        return CollectionUtils.isEmpty(this.registries) ? null : this.registries.get(0);
    }

    public void setRegistry(RegistryConfig registry) {
        ArrayList<RegistryConfig> registries = new ArrayList<RegistryConfig>(1);
        registries.add(registry);
        this.setRegistries(registries);
    }

    public List<RegistryConfig> getRegistries() {
        return this.registries;
    }

    public void setRegistries(List<? extends RegistryConfig> registries) {
        this.registries = registries;
    }

    @Parameter(excluded=true)
    public String getRegistryIds() {
        return this.registryIds;
    }

    public void setRegistryIds(String registryIds) {
        this.registryIds = registryIds;
    }

    public List<MethodConfig> getMethods() {
        return this.methods;
    }

    public void setMethods(List<? extends MethodConfig> methods) {
        this.methods = methods != null ? new ArrayList<MethodConfig>(methods) : null;
    }

    public void addMethod(MethodConfig methodConfig) {
        if (this.methods == null) {
            this.methods = new ArrayList<MethodConfig>();
        }
        this.methods.add(methodConfig);
    }

    public MonitorConfig getMonitor() {
        if (this.monitor != null) {
            return this.monitor;
        }
        return this.getConfigManager().getMonitor().orElse(null);
    }

    @Deprecated
    public void setMonitor(String monitor) {
        this.setMonitor(new MonitorConfig(monitor));
    }

    @Deprecated
    public void setMonitor(MonitorConfig monitor) {
        this.monitor = monitor;
        if (monitor != null) {
            this.getConfigManager().setMonitor(monitor);
        }
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Deprecated
    public ConfigCenterConfig getConfigCenter() {
        if (this.configCenter != null) {
            return this.configCenter;
        }
        Collection<ConfigCenterConfig> configCenterConfigs = this.getConfigManager().getConfigCenters();
        if (CollectionUtils.isNotEmpty(configCenterConfigs)) {
            return configCenterConfigs.iterator().next();
        }
        return null;
    }

    @Deprecated
    public void setConfigCenter(ConfigCenterConfig configCenter) {
        this.configCenter = configCenter;
        if (configCenter != null) {
            this.getConfigManager().addConfigCenter(configCenter);
        }
    }

    public Integer getCallbacks() {
        return this.callbacks;
    }

    public void setCallbacks(Integer callbacks) {
        this.callbacks = callbacks;
    }

    public String getOnconnect() {
        return this.onconnect;
    }

    public void setOnconnect(String onconnect) {
        this.onconnect = onconnect;
    }

    public String getOndisconnect() {
        return this.ondisconnect;
    }

    public void setOndisconnect(String ondisconnect) {
        this.ondisconnect = ondisconnect;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    @Deprecated
    public MetadataReportConfig getMetadataReportConfig() {
        if (this.metadataReportConfig != null) {
            return this.metadataReportConfig;
        }
        Collection<MetadataReportConfig> metadataReportConfigs = this.getConfigManager().getMetadataConfigs();
        if (CollectionUtils.isNotEmpty(metadataReportConfigs)) {
            return metadataReportConfigs.iterator().next();
        }
        return null;
    }

    @Deprecated
    public void setMetadataReportConfig(MetadataReportConfig metadataReportConfig) {
        this.metadataReportConfig = metadataReportConfig;
        if (metadataReportConfig != null) {
            this.getConfigManager().addMetadataReport(metadataReportConfig);
        }
    }

    @Parameter(key="dubbo.tag")
    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public Boolean getAuth() {
        return this.auth;
    }

    public void setAuth(Boolean auth) {
        this.auth = auth;
    }

    public SslConfig getSslConfig() {
        return this.getConfigManager().getSsl().orElse(null);
    }

    public Boolean getSingleton() {
        return this.singleton;
    }

    public void setSingleton(Boolean singleton) {
        this.singleton = singleton;
    }

    protected void initServiceMetadata(AbstractInterfaceConfig interfaceConfig) {
        this.serviceMetadata.setVersion(this.getVersion(interfaceConfig));
        this.serviceMetadata.setGroup(this.getGroup(interfaceConfig));
        this.serviceMetadata.setDefaultGroup(this.getGroup(interfaceConfig));
        this.serviceMetadata.setServiceInterfaceName(this.getInterface());
    }

    public String getGroup(AbstractInterfaceConfig interfaceConfig) {
        return StringUtils.isEmpty(this.getGroup()) ? (interfaceConfig != null ? interfaceConfig.getGroup() : this.getGroup()) : this.getGroup();
    }

    public String getVersion(AbstractInterfaceConfig interfaceConfig) {
        return StringUtils.isEmpty(this.getVersion()) ? (interfaceConfig != null ? interfaceConfig.getVersion() : this.getVersion()) : this.getVersion();
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getInterface() {
        return this.interfaceName;
    }

    public void setInterface(String interfaceName) {
        this.interfaceName = interfaceName;
    }

    @Transient
    public ClassLoader getInterfaceClassLoader() {
        return this.interfaceClassLoader;
    }

    public void setInterfaceClassLoader(ClassLoader interfaceClassLoader) {
        this.interfaceClassLoader = interfaceClassLoader;
    }
}

