/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.url.component.param;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import org.apache.dubbo.common.url.component.param.DynamicParamSource;
import org.apache.dubbo.common.url.component.param.DynamicValues;
import org.apache.dubbo.common.url.component.param.ParamValue;
import org.apache.dubbo.rpc.model.FrameworkModel;

public final class DynamicParamTable {
    private static int[] KEYS;
    private static String[] ORIGIN_KEYS;
    private static ParamValue[] VALUES;
    private static final Map<String, Integer> KEY2INDEX;

    private DynamicParamTable() {
        throw new IllegalStateException();
    }

    public static int getKeyIndex(boolean enabled, String key) {
        if (!enabled) {
            return -1;
        }
        int identityHashCode = System.identityHashCode(key);
        int index = Arrays.binarySearch(KEYS, identityHashCode);
        if (index >= 0) {
            return index;
        }
        Integer indexFromMap = KEY2INDEX.get(key);
        return indexFromMap == null ? -1 : indexFromMap;
    }

    public static int getValueIndex(String key, String value) {
        int idx = DynamicParamTable.getKeyIndex(true, key);
        if (idx < 0) {
            throw new IllegalArgumentException("Cannot found key in url param:" + key);
        }
        ParamValue paramValue = VALUES[idx];
        return paramValue.getIndex(value);
    }

    public static String getKey(int offset) {
        return ORIGIN_KEYS[offset];
    }

    public static String getValue(int vi, int offset) {
        return VALUES[vi].getN(offset);
    }

    private static void init() {
        int i;
        LinkedList<String> keys = new LinkedList<String>();
        LinkedList<DynamicValues> values = new LinkedList<DynamicValues>();
        HashMap<String, Integer> key2Index = new HashMap<String, Integer>(64);
        keys.add("");
        values.add(new DynamicValues(null));
        FrameworkModel.defaultModel().getExtensionLoader(DynamicParamSource.class).getSupportedExtensionInstances().forEach(source -> source.init(keys, values));
        TreeMap<String, ParamValue> resultMap = new TreeMap<String, ParamValue>(Comparator.comparingInt(System::identityHashCode));
        for (i = 0; i < keys.size(); ++i) {
            resultMap.put((String)keys.get(i), (ParamValue)values.get(i));
        }
        KEYS = resultMap.keySet().stream().map(System::identityHashCode).mapToInt(x -> x).toArray();
        ORIGIN_KEYS = resultMap.keySet().toArray(new String[0]);
        VALUES = resultMap.values().toArray(new ParamValue[0]);
        for (i = 0; i < ORIGIN_KEYS.length; ++i) {
            key2Index.put(ORIGIN_KEYS[i], i);
        }
        KEY2INDEX.putAll(key2Index);
    }

    static {
        KEY2INDEX = new HashMap<String, Integer>(64);
        DynamicParamTable.init();
    }
}

