/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.serialize.ObjectInput;
import org.apache.dubbo.common.serialize.ObjectOutput;
import org.apache.dubbo.common.serialize.Serialization;
import org.apache.dubbo.common.serialize.SerializationException;

public class DefaultSerializationExceptionWrapper
implements Serialization {
    private final Serialization serialization;

    public DefaultSerializationExceptionWrapper(Serialization serialization) {
        if (serialization == null) {
            throw new IllegalArgumentException("serialization == null");
        }
        this.serialization = serialization;
    }

    @Override
    public byte getContentTypeId() {
        return this.serialization.getContentTypeId();
    }

    @Override
    public String getContentType() {
        return this.serialization.getContentType();
    }

    @Override
    public ObjectOutput serialize(URL url, OutputStream output) throws IOException {
        ObjectOutput objectOutput = this.serialization.serialize(url, output);
        return new ProxyObjectOutput(objectOutput);
    }

    @Override
    public ObjectInput deserialize(URL url, InputStream input) throws IOException {
        ObjectInput objectInput = this.serialization.deserialize(url, input);
        return new ProxyObjectInput(objectInput);
    }

    private static IOException handleToIOException(Exception e) {
        if (!(e instanceof IOException)) {
            return new IOException(new SerializationException(e));
        }
        return (IOException)e;
    }

    static class ProxyObjectOutput
    implements ObjectOutput {
        private final ObjectOutput target;

        public ProxyObjectOutput(ObjectOutput target) {
            this.target = target;
        }

        @Override
        public void writeBool(boolean v) throws IOException {
            try {
                this.target.writeBool(v);
            }
            catch (Exception e) {
                throw DefaultSerializationExceptionWrapper.handleToIOException(e);
            }
        }

        @Override
        public void writeByte(byte v) throws IOException {
            try {
                this.target.writeByte(v);
            }
            catch (Exception e) {
                throw DefaultSerializationExceptionWrapper.handleToIOException(e);
            }
        }

        @Override
        public void writeShort(short v) throws IOException {
            try {
                this.target.writeShort(v);
            }
            catch (Exception e) {
                throw DefaultSerializationExceptionWrapper.handleToIOException(e);
            }
        }

        @Override
        public void writeInt(int v) throws IOException {
            try {
                this.target.writeInt(v);
            }
            catch (Exception e) {
                throw DefaultSerializationExceptionWrapper.handleToIOException(e);
            }
        }

        @Override
        public void writeLong(long v) throws IOException {
            try {
                this.target.writeLong(v);
            }
            catch (Exception e) {
                throw DefaultSerializationExceptionWrapper.handleToIOException(e);
            }
        }

        @Override
        public void writeFloat(float v) throws IOException {
            try {
                this.target.writeFloat(v);
            }
            catch (Exception e) {
                throw DefaultSerializationExceptionWrapper.handleToIOException(e);
            }
        }

        @Override
        public void writeDouble(double v) throws IOException {
            try {
                this.target.writeDouble(v);
            }
            catch (Exception e) {
                throw DefaultSerializationExceptionWrapper.handleToIOException(e);
            }
        }

        @Override
        public void writeUTF(String v) throws IOException {
            try {
                this.target.writeUTF(v);
            }
            catch (Exception e) {
                throw DefaultSerializationExceptionWrapper.handleToIOException(e);
            }
        }

        @Override
        public void writeBytes(byte[] v) throws IOException {
            try {
                this.target.writeBytes(v);
            }
            catch (Exception e) {
                throw DefaultSerializationExceptionWrapper.handleToIOException(e);
            }
        }

        @Override
        public void writeBytes(byte[] v, int off, int len) throws IOException {
            try {
                this.target.writeBytes(v);
            }
            catch (Exception e) {
                throw DefaultSerializationExceptionWrapper.handleToIOException(e);
            }
        }

        @Override
        public void flushBuffer() throws IOException {
            try {
                this.target.flushBuffer();
            }
            catch (Exception e) {
                throw DefaultSerializationExceptionWrapper.handleToIOException(e);
            }
        }

        @Override
        public void writeObject(Object obj) throws IOException {
            try {
                this.target.writeObject(obj);
            }
            catch (Exception e) {
                throw DefaultSerializationExceptionWrapper.handleToIOException(e);
            }
        }

        @Override
        public void writeThrowable(Throwable obj) throws IOException {
            try {
                this.target.writeThrowable(obj);
            }
            catch (Exception e) {
                throw DefaultSerializationExceptionWrapper.handleToIOException(e);
            }
        }

        @Override
        public void writeEvent(String data) throws IOException {
            try {
                this.target.writeEvent(data);
            }
            catch (Exception e) {
                throw DefaultSerializationExceptionWrapper.handleToIOException(e);
            }
        }

        @Override
        public void writeAttachments(Map<String, Object> attachments) throws IOException {
            try {
                this.target.writeAttachments(attachments);
            }
            catch (Exception e) {
                throw DefaultSerializationExceptionWrapper.handleToIOException(e);
            }
        }
    }

    static class ProxyObjectInput
    implements ObjectInput {
        private final ObjectInput target;

        public ProxyObjectInput(ObjectInput target) {
            this.target = target;
        }

        @Override
        public boolean readBool() throws IOException {
            try {
                return this.target.readBool();
            }
            catch (Exception e) {
                throw DefaultSerializationExceptionWrapper.handleToIOException(e);
            }
        }

        @Override
        public byte readByte() throws IOException {
            try {
                return this.target.readByte();
            }
            catch (Exception e) {
                throw DefaultSerializationExceptionWrapper.handleToIOException(e);
            }
        }

        @Override
        public short readShort() throws IOException {
            try {
                return this.target.readShort();
            }
            catch (Exception e) {
                throw DefaultSerializationExceptionWrapper.handleToIOException(e);
            }
        }

        @Override
        public int readInt() throws IOException {
            try {
                return this.target.readInt();
            }
            catch (Exception e) {
                throw DefaultSerializationExceptionWrapper.handleToIOException(e);
            }
        }

        @Override
        public long readLong() throws IOException {
            try {
                return this.target.readLong();
            }
            catch (Exception e) {
                throw DefaultSerializationExceptionWrapper.handleToIOException(e);
            }
        }

        @Override
        public float readFloat() throws IOException {
            try {
                return this.target.readFloat();
            }
            catch (Exception e) {
                throw DefaultSerializationExceptionWrapper.handleToIOException(e);
            }
        }

        @Override
        public double readDouble() throws IOException {
            try {
                return this.target.readDouble();
            }
            catch (Exception e) {
                throw DefaultSerializationExceptionWrapper.handleToIOException(e);
            }
        }

        @Override
        public String readUTF() throws IOException {
            try {
                return this.target.readUTF();
            }
            catch (Exception e) {
                throw DefaultSerializationExceptionWrapper.handleToIOException(e);
            }
        }

        @Override
        public byte[] readBytes() throws IOException {
            try {
                return this.target.readBytes();
            }
            catch (Exception e) {
                throw DefaultSerializationExceptionWrapper.handleToIOException(e);
            }
        }

        @Override
        public Object readObject() throws IOException, ClassNotFoundException {
            try {
                return this.target.readObject();
            }
            catch (Exception e) {
                throw DefaultSerializationExceptionWrapper.handleToIOException(e);
            }
        }

        @Override
        public <T> T readObject(Class<T> cls) throws IOException, ClassNotFoundException {
            try {
                return this.target.readObject(cls);
            }
            catch (Exception e) {
                throw DefaultSerializationExceptionWrapper.handleToIOException(e);
            }
        }

        @Override
        public <T> T readObject(Class<T> cls, Type type) throws IOException, ClassNotFoundException {
            try {
                return this.target.readObject(cls, type);
            }
            catch (Exception e) {
                throw DefaultSerializationExceptionWrapper.handleToIOException(e);
            }
        }

        @Override
        public Throwable readThrowable() throws IOException {
            try {
                return this.target.readThrowable();
            }
            catch (Exception e) {
                throw DefaultSerializationExceptionWrapper.handleToIOException(e);
            }
        }

        @Override
        public String readEvent() throws IOException {
            try {
                return this.target.readEvent();
            }
            catch (Exception e) {
                throw DefaultSerializationExceptionWrapper.handleToIOException(e);
            }
        }

        @Override
        public Map<String, Object> readAttachments() throws IOException, ClassNotFoundException {
            try {
                return this.target.readAttachments();
            }
            catch (Exception e) {
                if (e instanceof ClassNotFoundException) {
                    throw e;
                }
                throw DefaultSerializationExceptionWrapper.handleToIOException(e);
            }
        }
    }
}

