/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.netty4;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.Promise;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.api.WireProtocol;
import org.apache.dubbo.remoting.api.connection.AbstractConnectionClient;
import org.apache.dubbo.remoting.transport.netty4.NettyChannel;
import org.apache.dubbo.remoting.transport.netty4.NettyConfigOperator;
import org.apache.dubbo.remoting.transport.netty4.NettyConnectionHandler;
import org.apache.dubbo.remoting.transport.netty4.NettyEventLoopFactory;
import org.apache.dubbo.remoting.transport.netty4.NettySslContextOperator;
import org.apache.dubbo.remoting.transport.netty4.ssl.SslClientTlsHandler;
import org.apache.dubbo.remoting.transport.netty4.ssl.SslContexts;
import org.apache.dubbo.remoting.utils.UrlUtils;

public class NettyConnectionClient
extends AbstractConnectionClient {
    private static final ErrorTypeAwareLogger LOGGER = LoggerFactory.getErrorTypeAwareLogger(NettyConnectionClient.class);
    private AtomicReference<Promise<Object>> connectingPromise;
    private Promise<Void> closePromise;
    private AtomicReference<io.netty.channel.Channel> channel;
    private ConnectionListener connectionListener;
    private Bootstrap bootstrap;
    public static final AttributeKey<AbstractConnectionClient> CONNECTION = AttributeKey.valueOf((String)"connection");

    public NettyConnectionClient(URL url, ChannelHandler handler) throws RemotingException {
        super(url, handler);
    }

    @Override
    protected void initConnectionClient() {
        this.protocol = this.getUrl().getOrDefaultFrameworkModel().getExtensionLoader(WireProtocol.class).getExtension(this.getUrl().getProtocol());
        this.remote = this.getConnectAddress();
        this.connectingPromise = new AtomicReference();
        this.connectionListener = new ConnectionListener();
        this.channel = new AtomicReference();
        this.closePromise = new DefaultPromise((EventExecutor)GlobalEventExecutor.INSTANCE);
        this.init = new AtomicBoolean(false);
        this.increase();
    }

    @Override
    protected void doOpen() throws Throwable {
        this.initConnectionClient();
        this.initBootstrap();
    }

    private void initBootstrap() {
        Bootstrap nettyBootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)nettyBootstrap.group((EventLoopGroup)NettyEventLoopFactory.NIO_EVENT_LOOP_GROUP.get())).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).remoteAddress((SocketAddress)this.getConnectAddress()).channel(NettyEventLoopFactory.socketChannelClass());
        final NettyConnectionHandler connectionHandler = new NettyConnectionHandler(this);
        nettyBootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.getConnectTimeout());
        final SslContext sslContext = SslContexts.buildClientSslContext(this.getUrl());
        nettyBootstrap.handler((io.netty.channel.ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                NettyChannel nettyChannel = NettyChannel.getOrAddChannel((io.netty.channel.Channel)ch, NettyConnectionClient.this.getUrl(), NettyConnectionClient.this.getChannelHandler());
                ChannelPipeline pipeline = ch.pipeline();
                NettySslContextOperator nettySslContextOperator = new NettySslContextOperator();
                if (sslContext != null) {
                    pipeline.addLast("negotiation", (io.netty.channel.ChannelHandler)new SslClientTlsHandler(sslContext));
                }
                int heartbeat = UrlUtils.getHeartbeat(NettyConnectionClient.this.getUrl());
                pipeline.addLast("client-idle-handler", (io.netty.channel.ChannelHandler)new IdleStateHandler((long)heartbeat, 0L, 0L, TimeUnit.MILLISECONDS));
                pipeline.addLast("connectionHandler", (io.netty.channel.ChannelHandler)connectionHandler);
                NettyConfigOperator operator = new NettyConfigOperator(nettyChannel, NettyConnectionClient.this.getChannelHandler());
                NettyConnectionClient.this.protocol.configClientPipeline(NettyConnectionClient.this.getUrl(), operator, nettySslContextOperator);
                ch.closeFuture().addListener(channelFuture -> NettyConnectionClient.this.doClose());
            }
        });
        this.bootstrap = nettyBootstrap;
    }

    @Override
    protected void doClose() {
        if (this.isClosed()) {
            io.netty.channel.Channel current;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Connection:%s freed ", this));
            }
            if ((current = this.getNettyChannel()) != null) {
                current.close();
            }
            this.channel.set(null);
            this.closePromise.setSuccess(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doConnect() throws RemotingException {
        if (this.isClosed() && LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("%s aborted to reconnect cause connection closed. ", this));
        }
        this.init.compareAndSet(false, true);
        long start = System.currentTimeMillis();
        this.createConnectingPromise();
        ChannelFuture promise = this.bootstrap.connect();
        promise.addListener((GenericFutureListener)this.connectionListener);
        boolean ret = this.connectingPromise.get().awaitUninterruptibly((long)this.getConnectTimeout(), TimeUnit.MILLISECONDS);
        NettyConnectionClient nettyConnectionClient = this;
        synchronized (nettyConnectionClient) {
            this.connectingPromise.set(null);
        }
        if (promise.cause() != null) {
            Throwable cause = promise.cause();
            RemotingException remotingException = new RemotingException(this, "client(url: " + this.getUrl() + ") failed to connect to server " + this.getConnectAddress() + ", error message is:" + cause.getMessage(), cause);
            LOGGER.error("6-1", "network disconnected", "", "Failed to connect to provider server by other reason.", cause);
            throw remotingException;
        }
        if (!ret || !promise.isSuccess()) {
            RemotingException remotingException = new RemotingException((Channel)this, "client(url: " + this.getUrl() + ") failed to connect to server " + this.getConnectAddress() + " client-side timeout " + this.getConnectTimeout() + "ms (elapsed: " + (System.currentTimeMillis() - start) + "ms) from netty client " + NetUtils.getLocalHost() + " using dubbo version " + Version.getVersion());
            LOGGER.error("6-2", "provider crash", "", "Client-side timeout.", remotingException);
            throw remotingException;
        }
    }

    @Override
    protected void doDisConnect() {
        NettyChannel.removeChannelIfDisconnected(this.getNettyChannel());
    }

    @Override
    public void onConnected(Object channel) {
        if (!(channel instanceof io.netty.channel.Channel)) {
            return;
        }
        io.netty.channel.Channel nettyChannel = (io.netty.channel.Channel)channel;
        if (this.isClosed()) {
            nettyChannel.close();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("%s is closed, ignoring connected event", this));
            }
            return;
        }
        this.channel.set(nettyChannel);
        if (this.connectingPromise.get() != null) {
            this.connectingPromise.get().trySuccess(CONNECTED_OBJECT);
        }
        nettyChannel.attr(CONNECTION).set((Object)this);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("%s connected ", this));
        }
    }

    @Override
    public void onGoaway(Object channel) {
        if (!(channel instanceof io.netty.channel.Channel)) {
            return;
        }
        io.netty.channel.Channel nettyChannel = (io.netty.channel.Channel)channel;
        if (this.channel.compareAndSet(nettyChannel, null)) {
            NettyChannel.removeChannelIfDisconnected(nettyChannel);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("%s goaway", this));
            }
        }
    }

    @Override
    protected Channel getChannel() {
        io.netty.channel.Channel c = this.getNettyChannel();
        if (c == null) {
            return null;
        }
        return NettyChannel.getOrAddChannel(c, this.getUrl(), this);
    }

    io.netty.channel.Channel getNettyChannel() {
        return this.channel.get();
    }

    @Override
    public Object getChannel(Boolean generalizable) {
        return Boolean.TRUE.equals(generalizable) ? this.getNettyChannel() : this.getChannel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAvailable() {
        if (this.isClosed()) {
            return false;
        }
        io.netty.channel.Channel nettyChannel = this.getNettyChannel();
        if (nettyChannel != null && nettyChannel.isActive()) {
            return true;
        }
        if (this.init.compareAndSet(false, true)) {
            try {
                this.doConnect();
            }
            catch (RemotingException e) {
                LOGGER.error("6-16", "", "", "Failed to connect to server: " + this.getConnectAddress());
            }
        }
        this.createConnectingPromise();
        this.connectingPromise.get().awaitUninterruptibly((long)this.getConnectTimeout(), TimeUnit.MILLISECONDS);
        NettyConnectionClient nettyConnectionClient = this;
        synchronized (nettyConnectionClient) {
            this.connectingPromise.set(null);
        }
        nettyChannel = this.getNettyChannel();
        return nettyChannel != null && nettyChannel.isActive();
    }

    @Override
    public void createConnectingPromise() {
        this.connectingPromise.compareAndSet(null, (Promise<Object>)new DefaultPromise((EventExecutor)GlobalEventExecutor.INSTANCE));
    }

    public Promise<Void> getClosePromise() {
        return this.closePromise;
    }

    public static AbstractConnectionClient getConnectionClientFromChannel(io.netty.channel.Channel channel) {
        return (AbstractConnectionClient)channel.attr(CONNECTION).get();
    }

    public ChannelFuture write(Object request) throws RemotingException {
        if (!this.isAvailable()) {
            throw new RemotingException(null, null, "Failed to send request " + request + ", cause: The channel to " + this.remote + " is closed!");
        }
        return ((io.netty.channel.Channel)this.getChannel()).writeAndFlush(request);
    }

    @Override
    public void addCloseListener(Runnable func) {
        this.getClosePromise().addListener(future -> func.run());
    }

    @Override
    public void destroy() {
        this.close();
    }

    @Override
    public String toString() {
        return super.toString() + " (Ref=" + this.getCounter() + ",local=" + (this.getChannel() == null ? null : this.getChannel().getLocalAddress()) + ",remote=" + this.getRemoteAddress();
    }

    class ConnectionListener
    implements ChannelFutureListener {
        ConnectionListener() {
        }

        public void operationComplete(ChannelFuture future) {
            if (future.isSuccess()) {
                return;
            }
            NettyConnectionClient connectionClient = NettyConnectionClient.this;
            if (connectionClient.isClosed() || connectionClient.getCounter() == 0L) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("%s aborted to reconnect. %s", connectionClient, future.cause().getMessage()));
                }
                return;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("%s is reconnecting, attempt=%d cause=%s", connectionClient, 0, future.cause().getMessage()));
            }
            EventLoop loop = future.channel().eventLoop();
            loop.schedule(() -> {
                try {
                    connectionClient.doConnect();
                }
                catch (RemotingException e) {
                    LOGGER.error("6-16", "", "", "Failed to connect to server: " + NettyConnectionClient.this.getConnectAddress());
                }
            }, 1L, TimeUnit.SECONDS);
        }
    }
}

