/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.xds.util.protocol.message;

import io.envoyproxy.envoy.config.route.v3.VirtualHost;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.utils.ConcurrentHashSet;

public class RouteResult {
    private final Map<String, Set<String>> domainMap;
    private Map<String, VirtualHost> virtualHostMap;

    public RouteResult() {
        this.domainMap = new ConcurrentHashMap<String, Set<String>>();
        this.virtualHostMap = new ConcurrentHashMap<String, VirtualHost>();
    }

    public RouteResult(Map<String, Set<String>> domainMap) {
        this.domainMap = domainMap;
        this.virtualHostMap = new ConcurrentHashMap<String, VirtualHost>();
    }

    public RouteResult(Map<String, Set<String>> domainMap, Map<String, VirtualHost> virtualHostMap) {
        this.domainMap = domainMap;
        this.virtualHostMap = virtualHostMap;
    }

    public Map<String, Set<String>> getDomainMap() {
        return this.domainMap;
    }

    public boolean isNotEmpty() {
        return !this.domainMap.isEmpty();
    }

    public Set<String> searchDomain(String domain) {
        return this.domainMap.getOrDefault(domain, new ConcurrentHashSet());
    }

    public Set<String> getDomains() {
        return Collections.unmodifiableSet(this.domainMap.keySet());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RouteResult that = (RouteResult)o;
        return Objects.equals(this.domainMap, that.domainMap) && Objects.equals(this.virtualHostMap, that.virtualHostMap);
    }

    public int hashCode() {
        return Objects.hash(this.domainMap, this.virtualHostMap);
    }

    public VirtualHost searchVirtualHost(String domain) {
        return this.virtualHostMap.get(domain);
    }

    public void removeVirtualHost(String domain) {
        this.virtualHostMap.remove(domain);
    }

    public String toString() {
        return "RouteResult{domainMap=" + this.domainMap + ", virtualHostMap=" + this.virtualHostMap + '}';
    }
}

