/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.rest;

import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.metadata.rest.JAXRSClassConstants;
import org.apache.dubbo.metadata.rest.SpringMvcClassConstants;
import org.apache.dubbo.metadata.rest.tag.BodyTag;
import org.apache.dubbo.metadata.rest.tag.ParamTag;

public enum ParamType {
    HEADER(ParamType.addSupportTypes(JAXRSClassConstants.HEADER_PARAM_ANNOTATION_CLASS, SpringMvcClassConstants.REQUEST_HEADER_ANNOTATION_CLASS)),
    PARAM(ParamType.addSupportTypes(JAXRSClassConstants.QUERY_PARAM_ANNOTATION_CLASS, SpringMvcClassConstants.REQUEST_PARAM_ANNOTATION_CLASS, ParamTag.class)),
    BODY(ParamType.addSupportTypes(JAXRSClassConstants.REST_EASY_BODY_ANNOTATION_CLASS, SpringMvcClassConstants.REQUEST_BODY_ANNOTATION_CLASS, BodyTag.class)),
    PATH(ParamType.addSupportTypes(JAXRSClassConstants.PATH_PARAM_ANNOTATION_CLASS, SpringMvcClassConstants.PATH_VARIABLE_ANNOTATION_CLASS)),
    FORM(ParamType.addSupportTypes(JAXRSClassConstants.FORM_PARAM_ANNOTATION_CLASS, SpringMvcClassConstants.REQUEST_BODY_ANNOTATION_CLASS)),
    PROVIDER_BODY(ParamType.addSupportTypes(JAXRSClassConstants.REST_EASY_BODY_ANNOTATION_CLASS, JAXRSClassConstants.FORM_PARAM_ANNOTATION_CLASS, SpringMvcClassConstants.REQUEST_BODY_ANNOTATION_CLASS, BodyTag.class)),
    EMPTY(ParamType.addSupportTypes(new Class[0]));

    private List<Class> annotationClasses;

    private ParamType(List<Class> annotationClasses) {
        this.annotationClasses = annotationClasses;
    }

    public boolean supportAnno(Class anno) {
        if (anno == null) {
            return false;
        }
        return this.annotationClasses.contains(anno);
    }

    private static List<Class> addSupportTypes(Class ... classes) {
        ArrayList<Class> types = new ArrayList<Class>();
        for (Class clazz : classes) {
            if (clazz == null) continue;
            types.add(clazz);
        }
        return types;
    }
}

