/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.convert.multiple;

import java.util.Collection;
import java.util.Optional;
import org.apache.dubbo.common.convert.ConverterUtil;
import org.apache.dubbo.common.convert.StringConverter;
import org.apache.dubbo.common.convert.multiple.StringToMultiValueConverter;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.common.utils.TypeUtils;
import org.apache.dubbo.rpc.model.FrameworkModel;

public abstract class StringToIterableConverter<T extends Iterable>
implements StringToMultiValueConverter {
    private ConverterUtil converterUtil;

    public StringToIterableConverter(FrameworkModel frameworkModel) {
        this.converterUtil = frameworkModel.getBeanFactory().getBean(ConverterUtil.class);
    }

    @Override
    public boolean accept(Class<String> type, Class<?> multiValueType) {
        return ClassUtils.isAssignableFrom(this.getSupportedType(), multiValueType);
    }

    @Override
    public final Object convert(String[] segments, int size, Class<?> multiValueType, Class<?> elementType) {
        Optional<StringConverter> stringConverter = this.getStringConverter(elementType);
        return stringConverter.map(converter -> {
            T convertedObject = this.createMultiValue(size, multiValueType);
            if (convertedObject instanceof Collection) {
                Collection collection = (Collection)convertedObject;
                for (int i = 0; i < size; ++i) {
                    String segment = segments[i];
                    Object element = converter.convert(segment);
                    collection.add(element);
                }
                return collection;
            }
            return convertedObject;
        }).orElse(null);
    }

    protected abstract T createMultiValue(int var1, Class<?> var2);

    protected Optional<StringConverter> getStringConverter(Class<?> elementType) {
        StringConverter converter = (StringConverter)this.converterUtil.getConverter(String.class, elementType);
        return Optional.ofNullable(converter);
    }

    protected final Class<T> getSupportedType() {
        return TypeUtils.findActualTypeArgument(this.getClass(), StringToIterableConverter.class, 0);
    }

    @Override
    public final int getPriority() {
        int level = ClassUtils.getAllInterfaces(this.getSupportedType(), type -> ClassUtils.isAssignableFrom(Iterable.class, type)).size();
        return Integer.MAX_VALUE - level;
    }
}

