/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.spring.security.filter;

import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.spring.security.jackson.ObjectMapperCodec;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

@Activate(group={"provider"}, order=-10000, onClass={"org.springframework.security.core.context.SecurityContextHolder", "org.springframework.security.jackson2.CoreJackson2Module", "com.fasterxml.jackson.databind.ObjectMapper"})
public class ContextHolderAuthenticationResolverFilter
implements Filter {
    private final ObjectMapperCodec mapper;

    public ContextHolderAuthenticationResolverFilter(ApplicationModel applicationModel) {
        this.mapper = applicationModel.getBeanFactory().getBean(ObjectMapperCodec.class);
    }

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        this.getSecurityContext(invocation);
        return invoker.invoke(invocation);
    }

    private void getSecurityContext(Invocation invocation) {
        String authenticationJSON = invocation.getAttachment("security_authentication_context");
        if (StringUtils.isBlank(authenticationJSON)) {
            return;
        }
        Authentication authentication = this.mapper.deserialize(authenticationJSON, Authentication.class);
        if (authentication == null) {
            return;
        }
        SecurityContextHolder.getContext().setAuthentication(authentication);
    }
}

