/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.spring.security.filter;

import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.BaseFilter;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.AuthenticationException;

@Activate(group={"provider"}, order=0x7FFFFFFF, onClass={"org.springframework.security.core.context.SecurityContextHolder", "org.springframework.security.jackson2.CoreJackson2Module", "com.fasterxml.jackson.databind.ObjectMapper"})
public class AuthenticationExceptionTranslatorFilter
implements Filter,
BaseFilter.Listener {
    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        return invoker.invoke(invocation);
    }

    @Override
    public void onResponse(Result result, Invoker<?> invoker, Invocation invocation) {
        if (this.isTranslate(result)) {
            RpcException rpcException = new RpcException(result.getException().getMessage());
            rpcException.setCode(13);
            result.setException(rpcException);
        }
    }

    @Override
    public void onError(Throwable t, Invoker<?> invoker, Invocation invocation) {
    }

    private boolean isTranslate(Result result) {
        Throwable exception = result.getException();
        return result.hasException() && (exception instanceof AuthenticationException || exception instanceof AccessDeniedException);
    }
}

