/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest.deploy;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.rest.PathMatcher;
import org.apache.dubbo.metadata.rest.RestMethodMetadata;
import org.apache.dubbo.metadata.rest.ServiceRestMetadata;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.protocol.rest.PathAndInvokerMapper;
import org.apache.dubbo.rpc.protocol.rest.RpcExceptionMapper;
import org.apache.dubbo.rpc.protocol.rest.exception.mapper.ExceptionMapper;
import org.apache.dubbo.rpc.protocol.rest.exception.mapper.RestEasyExceptionMapper;

public class ServiceDeployer {
    private final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(this.getClass());
    private final PathAndInvokerMapper pathAndInvokerMapper = new PathAndInvokerMapper();
    private final ExceptionMapper exceptionMapper = this.createExceptionMapper();
    private final Set<Object> extensions = new HashSet<Object>();

    public void deploy(ServiceRestMetadata serviceRestMetadata, Invoker invoker) {
        Map<PathMatcher, RestMethodMetadata> pathToServiceMapContainPathVariable = serviceRestMetadata.getPathContainPathVariableToServiceMap();
        this.pathAndInvokerMapper.addPathAndInvoker(pathToServiceMapContainPathVariable, invoker);
        Map<PathMatcher, RestMethodMetadata> pathToServiceMapUnContainPathVariable = serviceRestMetadata.getPathUnContainPathVariableToServiceMap();
        this.pathAndInvokerMapper.addPathAndInvoker(pathToServiceMapUnContainPathVariable, invoker);
    }

    public void undeploy(ServiceRestMetadata serviceRestMetadata) {
        Map<PathMatcher, RestMethodMetadata> pathToServiceMapContainPathVariable = serviceRestMetadata.getPathContainPathVariableToServiceMap();
        pathToServiceMapContainPathVariable.keySet().stream().forEach(this.pathAndInvokerMapper::removePath);
        Map<PathMatcher, RestMethodMetadata> pathToServiceMapUnContainPathVariable = serviceRestMetadata.getPathUnContainPathVariableToServiceMap();
        pathToServiceMapUnContainPathVariable.keySet().stream().forEach(this.pathAndInvokerMapper::removePath);
    }

    public void registerExtension(URL url) {
        for (String clazz : CommonConstants.COMMA_SPLIT_PATTERN.split(url.getParameter("extension", RpcExceptionMapper.class.getName()))) {
            if (StringUtils.isEmpty(clazz)) continue;
            try {
                Class<?> aClass = ClassUtils.forName(clazz);
                if (ExceptionMapper.isSupport(aClass)) {
                    this.exceptionMapper.registerMapper(clazz);
                    continue;
                }
                this.extensions.add(aClass.newInstance());
            }
            catch (Exception e) {
                this.logger.warn("", "", "dubbo rest registerExtension error: ", e.getMessage(), e);
            }
        }
    }

    public PathAndInvokerMapper getPathAndInvokerMapper() {
        return this.pathAndInvokerMapper;
    }

    public ExceptionMapper getExceptionMapper() {
        return this.exceptionMapper;
    }

    public Set<Object> getExtensions() {
        return this.extensions;
    }

    public <T> List<T> getExtensions(Class<T> extensionClass) {
        ArrayList<Object> exts = new ArrayList<Object>();
        if (this.extensions.isEmpty()) {
            return exts;
        }
        for (Object extension : this.extensions) {
            if (!extensionClass.isAssignableFrom(extension.getClass())) continue;
            exts.add(extension);
        }
        return exts;
    }

    private ExceptionMapper createExceptionMapper() {
        if (ClassUtils.isPresent("javax.ws.rs.ext.ExceptionMapper", Thread.currentThread().getContextClassLoader())) {
            return new RestEasyExceptionMapper();
        }
        return new ExceptionMapper();
    }
}

