/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.filter.support;

import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.metrics.collector.DefaultMetricsCollector;
import org.apache.dubbo.metrics.event.MetricsDispatcher;
import org.apache.dubbo.metrics.event.MetricsEventBus;
import org.apache.dubbo.metrics.event.RequestEvent;
import org.apache.dubbo.rpc.BaseFilter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.filter.ClusterFilter;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ScopeModelAware;

@Activate(group={"consumer"}, onClass={"org.apache.dubbo.metrics.collector.DefaultMetricsCollector"})
public class MetricsClusterFilter
implements ClusterFilter,
BaseFilter.Listener,
ScopeModelAware {
    private ApplicationModel applicationModel;
    private DefaultMetricsCollector collector;
    private String appName;
    private MetricsDispatcher metricsDispatcher;

    @Override
    public void setApplicationModel(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
        this.collector = applicationModel.getBeanFactory().getBean(DefaultMetricsCollector.class);
        this.appName = applicationModel.tryGetApplicationName();
        this.metricsDispatcher = applicationModel.getBeanFactory().getBean(MetricsDispatcher.class);
    }

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        return invoker.invoke(invocation);
    }

    @Override
    public void onResponse(Result result, Invoker<?> invoker, Invocation invocation) {
        this.handleMethodException(result.getException(), invocation);
    }

    @Override
    public void onError(Throwable t, Invoker<?> invoker, Invocation invocation) {
        this.handleMethodException(t, invocation);
    }

    private void handleMethodException(Throwable t, Invocation invocation) {
        RpcException e;
        if (this.collector == null || !this.collector.isCollectEnabled()) {
            return;
        }
        if (t instanceof RpcException && (e = (RpcException)t).isForbidden()) {
            MetricsEventBus.publish(RequestEvent.toRequestErrorEvent(this.applicationModel, this.appName, this.metricsDispatcher, invocation, "consumer", e.getCode()));
        }
    }
}

