/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.nacos;

import com.alibaba.nacos.api.naming.pojo.Instance;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.registry.NotifyListener;

public class NacosAggregateListener {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(NacosAggregateListener.class);
    private final NotifyListener notifyListener;
    private final Set<String> serviceNames = new ConcurrentHashSet<String>();
    private final Map<String, List<Instance>> serviceInstances = new ConcurrentHashMap<String, List<Instance>>();
    private final AtomicBoolean warned = new AtomicBoolean(false);
    private static final Pattern SPLITTED_PATTERN = Pattern.compile(".*:.*:.*:.*");

    public NacosAggregateListener(NotifyListener notifyListener) {
        this.notifyListener = notifyListener;
    }

    public List<Instance> saveAndAggregateAllInstances(String serviceName, List<Instance> instances) {
        this.serviceNames.add(serviceName);
        if (instances == null) {
            this.serviceInstances.remove(serviceName);
        } else {
            this.serviceInstances.put(serviceName, instances);
        }
        if (NacosAggregateListener.isLegacyName(serviceName) && instances != null && !instances.isEmpty() && this.warned.compareAndSet(false, true)) {
            logger.error("1-42", "", "", "Received not empty notification for legacy service name: " + serviceName + ", instances: [" + instances.stream().map(Instance::getIp).collect(Collectors.joining(" ,")) + "]. Please upgrade these Dubbo client(lower than 2.7.3) to the latest version. Dubbo will remove the support for legacy service name in the future.");
        }
        return this.serviceInstances.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static boolean isLegacyName(String serviceName) {
        return !SPLITTED_PATTERN.matcher(serviceName).matches();
    }

    public NotifyListener getNotifyListener() {
        return this.notifyListener;
    }

    public Set<String> getServiceNames() {
        return this.serviceNames;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NacosAggregateListener that = (NacosAggregateListener)o;
        return Objects.equals(this.notifyListener, that.notifyListener) && Objects.equals(this.serviceNames, that.serviceNames) && Objects.equals(this.serviceInstances, that.serviceInstances);
    }

    public int hashCode() {
        return Objects.hash(this.notifyListener, this.serviceNames, this.serviceInstances);
    }
}

