/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.command.impl;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.dubbo.common.utils.JsonUtils;
import org.apache.dubbo.metrics.report.DefaultMetricsReporter;
import org.apache.dubbo.metrics.report.MetricsReporter;
import org.apache.dubbo.qos.api.BaseCommand;
import org.apache.dubbo.qos.api.Cmd;
import org.apache.dubbo.qos.api.CommandContext;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.FrameworkModel;

@Cmd(name="metrics_default", summary="display metrics information")
public class DefaultMetricsReporterCmd
implements BaseCommand {
    public FrameworkModel frameworkModel;

    public DefaultMetricsReporterCmd(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
    }

    @Override
    public String execute(CommandContext commandContext, String[] args) {
        List<ApplicationModel> models = this.frameworkModel.getApplicationModels();
        String result = "There is no application with data";
        if (this.notSpecifyApplication(args)) {
            result = this.useFirst(models, result, null);
        } else if (args.length == 1) {
            result = this.specifyApplication(args[0], models, null);
        } else if (args.length == 2) {
            result = this.specifyApplication(args[0], models, args[1]);
        }
        return result;
    }

    private boolean notSpecifyApplication(String[] args) {
        return args == null || args.length == 0;
    }

    private String useFirst(List<ApplicationModel> models, String result, String metricsName) {
        for (ApplicationModel model : models) {
            String current = this.getResponseByApplication(model, metricsName);
            if (current == null || DefaultMetricsReporterCmd.getLineNumber(current) <= 0L) continue;
            result = current;
            break;
        }
        return result;
    }

    private String specifyApplication(String appName, List<ApplicationModel> models, String metricsName) {
        if ("application_all".equals(appName)) {
            return this.allApplication(models);
        }
        return this.specifySingleApplication(appName, models, metricsName);
    }

    private String specifySingleApplication(String appName, List<ApplicationModel> models, String metricsName) {
        Optional<ApplicationModel> modelOptional = models.stream().filter(applicationModel -> appName.equals(applicationModel.getApplicationName())).findFirst();
        if (modelOptional.isPresent()) {
            return this.getResponseByApplication(modelOptional.get(), metricsName);
        }
        return "Not exist application: " + appName;
    }

    private String allApplication(List<ApplicationModel> models) {
        HashMap<String, String> appResultMap = new HashMap<String, String>();
        for (ApplicationModel model : models) {
            appResultMap.put(model.getApplicationName(), this.getResponseByApplication(model, null));
        }
        return JsonUtils.toJson(appResultMap);
    }

    private String getResponseByApplication(ApplicationModel applicationModel, String metricsName) {
        String response = "DefaultMetricsReporter not init";
        MetricsReporter metricsReporter = applicationModel.getBeanFactory().getBean(DefaultMetricsReporter.class);
        if (metricsReporter != null) {
            metricsReporter.refreshData();
            response = metricsReporter.getResponseWithName(metricsName);
        }
        return response;
    }

    private static long getLineNumber(String content) {
        LineNumberReader lnr = new LineNumberReader(new CharArrayReader(content.toCharArray()));
        try {
            lnr.skip(Long.MAX_VALUE);
            lnr.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return lnr.getLineNumber();
    }
}

