/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.filter;

import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.config.MetricsConfig;
import org.apache.dubbo.metrics.collector.DefaultMetricsCollector;
import org.apache.dubbo.metrics.event.MetricsDispatcher;
import org.apache.dubbo.metrics.event.MetricsEventBus;
import org.apache.dubbo.metrics.event.RequestEvent;
import org.apache.dubbo.metrics.model.MetricsSupport;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ScopeModelAware;

public class MetricsFilter
implements ScopeModelAware {
    private ApplicationModel applicationModel;
    private static final ErrorTypeAwareLogger LOGGER = LoggerFactory.getErrorTypeAwareLogger(MetricsFilter.class);
    private boolean rpcMetricsEnable;
    private String appName;
    private MetricsDispatcher metricsDispatcher;
    private DefaultMetricsCollector defaultMetricsCollector;

    @Override
    public void setApplicationModel(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
        this.rpcMetricsEnable = applicationModel.getApplicationConfigManager().getMetrics().map(MetricsConfig::getEnableRpc).orElse(true);
        this.appName = applicationModel.tryGetApplicationName();
        this.metricsDispatcher = applicationModel.getBeanFactory().getBean(MetricsDispatcher.class);
        this.defaultMetricsCollector = applicationModel.getBeanFactory().getBean(DefaultMetricsCollector.class);
    }

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        return this.invoke(invoker, invocation, "provider".equals(MetricsSupport.getSide(invocation)));
    }

    public Result invoke(Invoker<?> invoker, Invocation invocation, boolean isProvider) throws RpcException {
        if (this.rpcMetricsEnable) {
            try {
                RequestEvent requestEvent = RequestEvent.toRequestEvent(this.applicationModel, this.appName, this.metricsDispatcher, this.defaultMetricsCollector, invocation, isProvider ? "provider" : "consumer");
                MetricsEventBus.before(requestEvent);
                invocation.put("metric_filter_event", requestEvent);
            }
            catch (Throwable t) {
                LOGGER.warn("99-0", "", "", "Error occurred when invoke.", t);
            }
        }
        return invoker.invoke(invocation);
    }

    public void onResponse(Result result, Invoker<?> invoker, Invocation invocation) {
        this.onResponse(result, invoker, invocation, "provider".equals(MetricsSupport.getSide(invocation)));
    }

    public void onResponse(Result result, Invoker<?> invoker, Invocation invocation, boolean isProvider) {
        Object eventObj = invocation.get("metric_filter_event");
        if (eventObj != null) {
            try {
                MetricsEventBus.after((RequestEvent)eventObj, result);
            }
            catch (Throwable t) {
                LOGGER.warn("99-0", "", "", "Error occurred when onResponse.", t);
            }
        }
    }

    public void onError(Throwable t, Invoker<?> invoker, Invocation invocation) {
        this.onError(t, invoker, invocation, "provider".equals(MetricsSupport.getSide(invocation)));
    }

    public void onError(Throwable t, Invoker<?> invoker, Invocation invocation, boolean isProvider) {
        Object eventObj = invocation.get("metric_filter_event");
        if (eventObj != null) {
            try {
                RequestEvent requestEvent = (RequestEvent)eventObj;
                requestEvent.putAttachment("metric_filter_throwable", t);
                MetricsEventBus.error(requestEvent);
            }
            catch (Throwable throwable) {
                LOGGER.warn("99-0", "", "", "Error occurred when onResponse.", throwable);
            }
        }
    }
}

