/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.event;

import org.apache.dubbo.common.beans.factory.ScopeBeanFactory;
import org.apache.dubbo.metrics.collector.DefaultMetricsCollector;
import org.apache.dubbo.metrics.event.MetricsDispatcher;
import org.apache.dubbo.metrics.event.TimeCounterEvent;
import org.apache.dubbo.metrics.exception.MetricsNeverHappenException;
import org.apache.dubbo.metrics.model.MethodMetric;
import org.apache.dubbo.metrics.model.MetricsSupport;
import org.apache.dubbo.metrics.model.key.MetricsKey;
import org.apache.dubbo.metrics.model.key.MetricsLevel;
import org.apache.dubbo.metrics.model.key.TypeWrapper;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class RequestEvent
extends TimeCounterEvent {
    private static final TypeWrapper REQUEST_EVENT = new TypeWrapper(MetricsLevel.SERVICE, MetricsKey.METRIC_REQUESTS, MetricsKey.METRIC_REQUESTS_SUCCEED, MetricsKey.METRIC_REQUEST_BUSINESS_FAILED);
    private static final TypeWrapper REQUEST_ERROR_EVENT = new TypeWrapper(MetricsLevel.METHOD, MetricsKey.METRIC_REQUESTS);

    public RequestEvent(ApplicationModel applicationModel, String appName, MetricsDispatcher metricsDispatcher, DefaultMetricsCollector collector, TypeWrapper TYPE_WRAPPER) {
        super(applicationModel, appName, metricsDispatcher, TYPE_WRAPPER);
        ScopeBeanFactory beanFactory;
        if (collector == null && !(beanFactory = applicationModel.getBeanFactory()).isDestroyed()) {
            collector = beanFactory.getBean(DefaultMetricsCollector.class);
        }
        super.setAvailable(collector != null && collector.isCollectEnabled());
    }

    public static RequestEvent toRequestEvent(ApplicationModel applicationModel, String appName, MetricsDispatcher metricsDispatcher, DefaultMetricsCollector collector, Invocation invocation, String side) {
        MethodMetric methodMetric = new MethodMetric(applicationModel, invocation);
        RequestEvent requestEvent = new RequestEvent(applicationModel, appName, metricsDispatcher, collector, REQUEST_EVENT);
        requestEvent.putAttachment("metric_filter_invocation", invocation);
        requestEvent.putAttachment("metric_filter_method_metrics", methodMetric);
        requestEvent.putAttachment("serviceKey", MetricsSupport.getInterfaceName(invocation));
        requestEvent.putAttachment("metric_filter_side", side);
        return requestEvent;
    }

    @Override
    public void customAfterPost(Object postResult) {
        if (postResult == null) {
            return;
        }
        if (!(postResult instanceof Result)) {
            throw new MetricsNeverHappenException("Result type error, postResult:" + postResult.getClass().getName());
        }
        super.putAttachment("metric_filter_throwable", ((Result)postResult).getException());
    }

    public static RequestEvent toRequestErrorEvent(ApplicationModel applicationModel, String appName, MetricsDispatcher metricsDispatcher, Invocation invocation, String side, int code) {
        RequestEvent event = new RequestEvent(applicationModel, appName, metricsDispatcher, null, REQUEST_ERROR_EVENT);
        event.putAttachment("serviceKey", MetricsSupport.getInterfaceName(invocation));
        event.putAttachment("metric_filter_side", side);
        event.putAttachment("metric_filter_invocation", invocation);
        event.putAttachment("metric_request_error", code);
        event.putAttachment("metric_filter_method_metrics", new MethodMetric(applicationModel, invocation));
        return event;
    }

    public boolean isRequestErrorEvent() {
        return super.getAttachmentValue("metric_request_error") != null;
    }
}

