/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.collector;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.metrics.DefaultConstants;
import org.apache.dubbo.metrics.collector.CombMetricsCollector;
import org.apache.dubbo.metrics.collector.sample.MetricsCountSampleConfigurer;
import org.apache.dubbo.metrics.collector.sample.MetricsSampler;
import org.apache.dubbo.metrics.collector.sample.SimpleMetricsCountSampler;
import org.apache.dubbo.metrics.collector.sample.ThreadPoolMetricsSampler;
import org.apache.dubbo.metrics.data.BaseStatComposite;
import org.apache.dubbo.metrics.data.MethodStatComposite;
import org.apache.dubbo.metrics.data.RtStatComposite;
import org.apache.dubbo.metrics.event.DefaultSubDispatcher;
import org.apache.dubbo.metrics.event.MetricsEvent;
import org.apache.dubbo.metrics.event.RequestEvent;
import org.apache.dubbo.metrics.model.ApplicationMetric;
import org.apache.dubbo.metrics.model.MetricsCategory;
import org.apache.dubbo.metrics.model.key.MetricsKey;
import org.apache.dubbo.metrics.model.key.MetricsLevel;
import org.apache.dubbo.metrics.model.key.MetricsPlaceValue;
import org.apache.dubbo.metrics.model.sample.CounterMetricSample;
import org.apache.dubbo.metrics.model.sample.MetricSample;
import org.apache.dubbo.rpc.model.ApplicationModel;

@Activate
public class DefaultMetricsCollector
extends CombMetricsCollector<RequestEvent> {
    private boolean collectEnabled = false;
    private volatile boolean threadpoolCollectEnabled = false;
    private final ThreadPoolMetricsSampler threadPoolSampler = new ThreadPoolMetricsSampler(this);
    private String applicationName;
    private final ApplicationModel applicationModel;
    private final List<MetricsSampler> samplers = new ArrayList<MetricsSampler>();
    public SimpleMetricsCountSampler<String, MetricsEvent.Type, ApplicationMetric> applicationSampler = new SimpleMetricsCountSampler<String, MetricsEvent.Type, ApplicationMetric>(){

        @Override
        public List<MetricSample> sample() {
            ArrayList<MetricSample> samples = new ArrayList<MetricSample>();
            this.getCount(MetricsEvent.Type.APPLICATION_INFO).filter(e -> !e.isEmpty()).ifPresent(map -> map.forEach((k, v) -> samples.add(new CounterMetricSample<AtomicLong>(MetricsKey.APPLICATION_METRIC_INFO.getName(), MetricsKey.APPLICATION_METRIC_INFO.getDescription(), k.getTags(), MetricsCategory.APPLICATION, (AtomicLong)v))));
            return samples;
        }

        @Override
        protected void countConfigure(MetricsCountSampleConfigurer<String, MetricsEvent.Type, ApplicationMetric> sampleConfigure) {
            sampleConfigure.configureMetrics(configure -> new ApplicationMetric(DefaultMetricsCollector.this.applicationModel));
        }
    };

    public DefaultMetricsCollector(ApplicationModel applicationModel) {
        super(new BaseStatComposite(applicationModel){

            @Override
            protected void init(MethodStatComposite methodStatComposite) {
                super.init(methodStatComposite);
                methodStatComposite.initWrapper(DefaultConstants.METHOD_LEVEL_KEYS);
            }

            @Override
            protected void init(RtStatComposite rtStatComposite) {
                super.init(rtStatComposite);
                rtStatComposite.init(MetricsPlaceValue.of("provider", MetricsLevel.METHOD), MetricsPlaceValue.of("consumer", MetricsLevel.METHOD));
            }
        });
        super.setEventMulticaster(new DefaultSubDispatcher(this));
        this.samplers.add(this.applicationSampler);
        this.samplers.add(this.threadPoolSampler);
        this.applicationModel = applicationModel;
    }

    public void addSampler(MetricsSampler sampler) {
        this.samplers.add(sampler);
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public ApplicationModel getApplicationModel() {
        return this.applicationModel;
    }

    public void setCollectEnabled(Boolean collectEnabled) {
        this.collectEnabled = collectEnabled;
    }

    @Override
    public boolean isCollectEnabled() {
        return this.collectEnabled;
    }

    public boolean isThreadpoolCollectEnabled() {
        return this.threadpoolCollectEnabled;
    }

    public void setThreadpoolCollectEnabled(boolean threadpoolCollectEnabled) {
        this.threadpoolCollectEnabled = threadpoolCollectEnabled;
    }

    public void collectApplication() {
        this.setApplicationName(this.applicationModel.getApplicationName());
        this.applicationSampler.inc(this.applicationName, MetricsEvent.Type.APPLICATION_INFO);
    }

    public void registryDefaultSample() {
        this.threadPoolSampler.registryDefaultSampleThreadPoolExecutor();
    }

    @Override
    public List<MetricSample> collect() {
        ArrayList<MetricSample> list = new ArrayList<MetricSample>();
        if (!this.isCollectEnabled()) {
            return list;
        }
        for (MetricsSampler sampler : this.samplers) {
            List<MetricSample> sample = sampler.sample();
            list.addAll(sample);
        }
        list.addAll(super.export(MetricsCategory.REQUESTS));
        return list;
    }

    @Override
    public boolean isSupport(MetricsEvent event) {
        return event instanceof RequestEvent;
    }
}

